/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.serialization;

import static org.mule.tooling.client.api.extension.model.ExpressionSupport.notSupportedExpressionSupport;
import static org.mule.tooling.client.api.extension.model.ExpressionSupport.requiredExpressionSupport;
import static org.mule.tooling.client.api.extension.model.ExpressionSupport.supportedExpressionSupport;
import org.mule.tooling.client.api.extension.model.ExpressionSupport;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

import java.io.IOException;

/**
 * {@link TypeAdapter} for {@link ExpressionSupport}.
 */
public class ExpressionSupportTypeAdapter extends TypeAdapter<ExpressionSupport> {

  @Override
  public void write(JsonWriter out, ExpressionSupport expressionSupport) throws IOException {
    out.value(expressionSupport.getValue());
  }

  @Override
  public ExpressionSupport read(JsonReader in) throws IOException {
    String value = in.nextString();
    switch (value) {
      case "SUPPORTED":
        return supportedExpressionSupport(value);
      case "NOT_SUPPORTED":
        return notSupportedExpressionSupport(value);
      case "REQUIRED":
        return requiredExpressionSupport(value);
      default:
        return new ExpressionSupport(value);
    }
  }

}
