/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.serialization;

import static org.mule.tooling.client.api.extension.model.parameter.ParameterRole.behaviourParameterRole;
import static org.mule.tooling.client.api.extension.model.parameter.ParameterRole.contentParameterRole;
import static org.mule.tooling.client.api.extension.model.parameter.ParameterRole.primaryContentParameterRole;
import org.mule.tooling.client.api.extension.model.parameter.ParameterRole;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

import java.io.IOException;

/**
 * {@link TypeAdapter} for {@link ParameterRole}.
 */
public class ParameterRoleTypeAdapter extends TypeAdapter<ParameterRole> {

  @Override
  public void write(JsonWriter out, ParameterRole parameterRole) throws IOException {
    out.value(parameterRole.getValue());
  }

  @Override
  public ParameterRole read(JsonReader in) throws IOException {
    String role = in.nextString();
    switch (role) {
      case "BEHAVIOUR":
        return behaviourParameterRole(role);
      case "CONTENT":
        return contentParameterRole(role);
      case "PRIMARY_CONTENT":
        return primaryContentParameterRole(role);
      default:
        return new ParameterRole(role);
    }
  }

}
