/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.extension.model.source;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.mule.tooling.client.api.extension.model.ComponentModel;
import org.mule.tooling.client.api.extension.model.DisplayModel;
import org.mule.tooling.client.api.extension.model.ErrorModel;
import org.mule.tooling.client.api.extension.model.OutputModel;
import org.mule.tooling.client.api.extension.model.StereotypeModel;
import org.mule.tooling.client.api.extension.model.metadata.MetadataKeyIdModel;
import org.mule.tooling.client.api.extension.model.nested.NestableElementModel;
import org.mule.tooling.client.api.extension.model.parameter.ParameterGroupModel;
import org.mule.tooling.client.api.extension.model.source.SourceCallbackModel;

public class SourceModel
implements ComponentModel {
    private String name;
    private String description;
    private List<ParameterGroupModel> parameterGroupModels;
    private DisplayModel displayModel;
    private OutputModel output;
    private OutputModel outputAttributes;
    private boolean transactional;
    private boolean requiresConnection;
    private boolean supportsStreaming;
    private StereotypeModel stereotype;
    private boolean hasResponse;
    private SourceCallbackModel successCallback;
    private SourceCallbackModel errorCallback;
    private SourceCallbackModel terminateCallbackModel;
    private Set<ErrorModel> errors;
    private List<? extends NestableElementModel> nestedComponents;
    private MetadataKeyIdModel metadataKeyIdModel;

    private SourceModel() {
    }

    public SourceModel(String name, String description, List<ParameterGroupModel> parameterGroupModels, DisplayModel displayModel, OutputModel output, OutputModel outputAttributes, boolean transactional, boolean requiresConnection, boolean supportsStreaming, StereotypeModel stereotype, boolean hasResponse, SourceCallbackModel successCallback, SourceCallbackModel errorCallback, SourceCallbackModel terminateCallbackModel, Set<ErrorModel> errors, List<? extends NestableElementModel> nestedComponents, MetadataKeyIdModel metadataKeyIdModel) {
        this.name = name;
        this.description = description;
        this.parameterGroupModels = parameterGroupModels;
        this.displayModel = displayModel;
        this.output = output;
        this.outputAttributes = outputAttributes;
        this.transactional = transactional;
        this.requiresConnection = requiresConnection;
        this.supportsStreaming = supportsStreaming;
        this.stereotype = stereotype;
        this.hasResponse = hasResponse;
        this.successCallback = successCallback;
        this.errorCallback = errorCallback;
        this.terminateCallbackModel = terminateCallbackModel;
        this.errors = errors;
        this.nestedComponents = nestedComponents;
        this.metadataKeyIdModel = metadataKeyIdModel;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<ParameterGroupModel> getParameterGroupModels() {
        return this.parameterGroupModels;
    }

    @Override
    public Optional<DisplayModel> getDisplayModel() {
        return Optional.ofNullable(this.displayModel);
    }

    public OutputModel getOutput() {
        return this.output;
    }

    public OutputModel getOutputAttributes() {
        return this.outputAttributes;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public boolean requiresConnection() {
        return this.requiresConnection;
    }

    public boolean supportsStreaming() {
        return this.supportsStreaming;
    }

    @Override
    public StereotypeModel getStereotype() {
        return this.stereotype;
    }

    public boolean hasResponse() {
        return this.hasResponse;
    }

    public Optional<SourceCallbackModel> getSuccessCallback() {
        return Optional.ofNullable(this.successCallback);
    }

    public Optional<SourceCallbackModel> getErrorCallback() {
        return Optional.ofNullable(this.errorCallback);
    }

    public Optional<SourceCallbackModel> getTerminateCallback() {
        return Optional.ofNullable(this.terminateCallbackModel);
    }

    @Override
    public Set<ErrorModel> getErrorModels() {
        return this.errors;
    }

    @Override
    public List<? extends NestableElementModel> getNestedComponents() {
        return this.nestedComponents;
    }

    public Optional<MetadataKeyIdModel> getMetadataKeyIdModel() {
        return Optional.ofNullable(this.metadataKeyIdModel);
    }

    public Optional<ParameterGroupModel> getParameterGroupModel(String name) {
        return this.parameterGroupModels.stream().filter(model -> model.getName().equals(name)).findFirst();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        return this.getClass().isInstance(obj) && this.name.equals(((SourceModel)obj).getName());
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

