/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.dataweave;

import org.mule.tooling.client.api.request.AbstractToolingRequest;
import org.mule.tooling.event.model.EventModel;

/**
 * Representation of a DataWeave preview request based on a JSON.
 */
public class DataWeavePreviewRequest extends AbstractToolingRequest {

  /**
   * DataWeave script to run.
   */
  private String script;

  /**
   * Representation of MuleEvent that will work as parameters for DW script.
   * Includes sample data and mime-type for message and variables.
   */
  private EventModel event;

  public EventModel getEvent() {
    return event;
  }

  public void setEvent(EventModel event) {
    this.event = event;
  }

  public String getScript() {
    return script;
  }

  public void setScript(String script) {
    this.script = script;
  }

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {

    private DataWeavePreviewRequest instance;

    private Builder() {
      instance = new DataWeavePreviewRequest();
    }

    public Builder withEvent(EventModel event) {
      this.instance.setEvent(event);
      return this;
    }

    public Builder withScript(String script) {
      this.instance.setScript(script);
      return this;
    }

    public Builder withRequestTimeout(long timeout) {
      this.instance.setRequestTimeout(timeout);
      return this;
    }

    public DataWeavePreviewRequest build() {
      return instance;
    }
  }
}
