/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.extension.model.metadata;

import static org.mule.tooling.client.api.feature.Feature.disabled;
import static org.mule.tooling.client.api.feature.Feature.enabled;

import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.api.feature.Feature;

/**
 * Model for a {@link org.mule.tooling.client.api.extension.model.source.SourceModel} and
 * {@link org.mule.tooling.client.api.extension.model.operation.OperationModel} parameters
 * that indicates that its a {@code MetadataKeyId}.
 *
 * @since 1.0
 */
public class MetadataKeyIdModel {

  private MetadataType type;
  private String parameterName;
  private Feature<String> categoryName;

  // Just needed in order to serialize this object
  private MetadataKeyIdModel() {}

  /**
   * Creates a new instance.
   *
   * @param type of the {@link org.mule.tooling.client.api.extension.model.parameter.ParameterModel} annotated with {@code MetadataKeyId}.
   */
  public MetadataKeyIdModel(MetadataType type, String parameterName, String categoryName) {
    this.type = type;
    this.parameterName = parameterName;
    this.categoryName = enabled(categoryName);
  }

  /**
   * @return the type of the {@link org.mule.tooling.client.api.extension.model.parameter.ParameterModel} annotated with {@code MetadataKeyId}.
   */
  public MetadataType getType() {
    return type;
  }

  /**
   * @return the parameter name that is considered as the {@code MetadataKeyId}.
   */
  public String getParameterName() {
    return parameterName;
  }

  /**
   * @return the category name of the {@code MetadataKeyId}
   */
  public Feature<String> getCategoryName() {
    return categoryName == null
        ? disabled()
        : categoryName;
  }
}
