/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.metadata;

import org.mule.tooling.client.api.exception.ServiceUnavailableException;
import org.mule.tooling.client.api.exception.ToolingException;

/**
 * Service for retrieving metadata.
 *
 * A {@code MetadataService}
 *
 * @since 1.0
 */
public interface MetadataService {

  /**
   * Returns a {@link MetadataResult} of {@link MetadataKeysContainer} described by {@link
   * MetadataKeysContainer#getKeys(String)}} of the associated
   * MetadataKeyProvider component identified by the given {@link MetadataKeysRequest}.
   *
   * @param metadataKeysRequest request to get the {@link MetadataKeysContainer}
   * @return Successful {@link MetadataResult} if the keys are successfully resolved Failure {@link MetadataResult} if there is an error while resolving the keys.
   * @throws ServiceUnavailableException if a connection exception happens when trying to connect to Mule Agent REST API.
   * @throws ToolingException if an unexpected error happens.
   */
  MetadataResult<MetadataKeysContainer> getMetadataKeys(MetadataKeysRequest metadataKeysRequest)
      throws ServiceUnavailableException;

}
