/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.serialization;

import org.mule.metadata.api.annotation.AccessibilityAnnotation;
import org.mule.metadata.api.annotation.DefaultValueAnnotation;
import org.mule.metadata.api.annotation.DescriptionAnnotation;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.annotation.EnumLabelsAnnotation;
import org.mule.metadata.api.annotation.ExampleAnnotation;
import org.mule.metadata.api.annotation.FieldOccurrenceAnnotation;
import org.mule.metadata.api.annotation.IntAnnotation;
import org.mule.metadata.api.annotation.LabelAnnotation;
import org.mule.metadata.api.annotation.LengthAnnotation;
import org.mule.metadata.api.annotation.NumberRangeAnnotation;
import org.mule.metadata.api.annotation.RegexPatternAnnotation;
import org.mule.metadata.api.annotation.TypeAliasAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.annotation.UniquesItemsAnnotation;
import org.mule.metadata.flatfile.FieldFormatAnnotation;
import org.mule.metadata.flatfile.SchemaConstructAnnotation;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.metadata.message.api.LocationAnnotation;
import org.mule.tooling.client.api.declaration.type.annotation.DefaultImplementingTypeAnnotation;
import org.mule.tooling.client.api.declaration.type.annotation.DisplayTypeAnnotation;
import org.mule.tooling.client.api.declaration.type.annotation.ExclusiveOptionalsTypeAnnotation;
import org.mule.tooling.client.api.declaration.type.annotation.ExpressionSupportAnnotation;
import org.mule.tooling.client.api.declaration.type.annotation.ExtensibleTypeAnnotation;
import org.mule.tooling.client.api.declaration.type.annotation.FlattenedTypeAnnotation;
import org.mule.tooling.client.api.declaration.type.annotation.LayoutTypeAnnotation;
import org.mule.tooling.client.api.declaration.type.annotation.ParameterDslAnnotation;
import org.mule.tooling.client.api.declaration.type.annotation.QNameTypeAnnotation;
import org.mule.tooling.client.api.declaration.type.annotation.StereotypeTypeAnnotation;
import org.mule.tooling.client.api.declaration.type.annotation.TypeDslAnnotation;

import com.google.common.collect.ImmutableMap;

import java.util.Map;

/**
 * List of mapped {@link TypeAnnotation typeAnnotations} from Mule APIs to this API.
 *
 * @since 1.0
 */
public final class TypeIdAnnotationMapper {

  public static Map<String, Class<? extends TypeAnnotation>> TYPE_ANNOTATIONS_MAPPING =
      ImmutableMap.<String, Class<? extends TypeAnnotation>>builder()
          // metadata api
          .put(LabelAnnotation.NAME, LabelAnnotation.class)
          .put(LengthAnnotation.NAME, LengthAnnotation.class)
          .put(AccessibilityAnnotation.NAME, AccessibilityAnnotation.class)
          .put(DefaultValueAnnotation.NAME, DefaultValueAnnotation.class)
          .put(DescriptionAnnotation.NAME, DescriptionAnnotation.class)
          .put(EnumAnnotation.NAME, EnumAnnotation.class)
          .put(ExampleAnnotation.NAME, ExampleAnnotation.class)
          .put(FieldOccurrenceAnnotation.NAME, FieldOccurrenceAnnotation.class)
          .put(IntAnnotation.NAME, IntAnnotation.class)
          .put(NumberRangeAnnotation.NAME, NumberRangeAnnotation.class)
          .put(RegexPatternAnnotation.NAME, RegexPatternAnnotation.class)
          .put(TypeIdAnnotation.NAME, TypeIdAnnotation.class)
          .put(UniquesItemsAnnotation.NAME, UniquesItemsAnnotation.class)
          .put(ClassInformationAnnotation.NAME, ClassInformationAnnotation.class)
          .put(TypeAliasAnnotation.NAME, TypeAliasAnnotation.class)
          // new type annotations added on metadata api
          .put(EnumLabelsAnnotation.NAME, EnumLabelsAnnotation.class)
          .put(LocationAnnotation.NAME, LocationAnnotation.class)

          // extensions api
          .put(DisplayTypeAnnotation.NAME, DisplayTypeAnnotation.class)
          .put(TypeDslAnnotation.NAME, TypeDslAnnotation.class)
          .put(ExpressionSupportAnnotation.NAME, ExpressionSupportAnnotation.class)
          .put(ExclusiveOptionalsTypeAnnotation.NAME, ExclusiveOptionalsTypeAnnotation.class)
          .put(ExtensibleTypeAnnotation.NAME, ExtensibleTypeAnnotation.class)
          .put(FlattenedTypeAnnotation.NAME, FlattenedTypeAnnotation.class)
          .put(LayoutTypeAnnotation.NAME, LayoutTypeAnnotation.class)
          .put(ParameterDslAnnotation.NAME, ParameterDslAnnotation.class)
          .put(QNameTypeAnnotation.NAME, QNameTypeAnnotation.class)
          .put(StereotypeTypeAnnotation.NAME, StereotypeTypeAnnotation.class)
          .put(DefaultImplementingTypeAnnotation.NAME, DefaultImplementingTypeAnnotation.class)

          // flat file
          .put(FieldFormatAnnotation.class.getSimpleName(), FieldFormatAnnotation.class)
          .put(SchemaConstructAnnotation.NAME, SchemaConstructAnnotation.class)
          .build();


  private TypeIdAnnotationMapper() {}
}
