/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.datasense;

import static java.lang.String.format;
import static java.util.Objects.requireNonNull;
import static org.apache.commons.lang3.ClassUtils.getShortClassName;
import org.mule.tooling.client.api.component.location.Location;
import org.mule.tooling.client.internal.datasense.DataSenseResolutionScopeVisitor;

/**
 * Resolves data sense at component level.
 *
 * @since 1.0
 */
public class ComponentResolutionScope implements DataSenseResolutionScope {

  private final Location location;

  /**
   * Creates an instance of the scope for the given component location.
   *
   * @param location {@link Location} for the component.
   */
  public ComponentResolutionScope(Location location) {
    requireNonNull(location, "location cannot be null");
    this.location = location;
  }

  /**
   * @return the component location to which data sense should be resolved.
   */
  public Location getLocation() {
    return this.location;
  }

  @Override
  public String toString() {
    return format("%s{location=%s}", getShortClassName(this.getClass()),
                  getLocation());
  }

  @Override
  public void accept(DataSenseResolutionScopeVisitor visitor) {
    visitor.visit(this);
  }

}
