/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.persistence;

import org.mule.metadata.api.annotation.TypeAnnotation;

/**
 * Class to allow serializer to identify when a {@link org.mule.metadata.api.annotation.TypeAnnotation} has been
 * replaced from the {@link java.util.Map} to instead use the {@link TypeAnnotation#getName()}. This will allow
 * serializer to check if it is possible to marshall or unmarshall a {@link TypeAnnotation}.
 *
 * @since 1.0
 */
public class TypeAnnotationEntryKey {

  private String typeId;

  public TypeAnnotationEntryKey(String typeId) {
    this.typeId = typeId;
  }

  public String getTypeId() {
    return typeId;
  }

  public void setTypeId(String typeId) {
    this.typeId = typeId;
  }
}
