/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.serialization;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.MapConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.LinkedHashMap;
import java.util.Map;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.tooling.client.internal.persistence.TypeAnnotationEntryKey;
import org.mule.tooling.client.internal.serialization.Serializer;
import org.mule.tooling.client.internal.serialization.TypeIdAnnotationMapper;
import org.mule.tooling.client.internal.serialization.XStreamFactory;
import org.mule.tooling.client.internal.serialization.XmlArtifactDeserializationRequestConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XStreamClientSerializer
implements Serializer {
    public static String NAME = "xStream";
    private static Logger LOGGER = LoggerFactory.getLogger(XStreamClientSerializer.class);

    private static XStream createXStream() {
        XStream xStream = XStreamFactory.createXStream();
        xStream.registerConverter((Converter)new TypeAnnotationsMapConverter(xStream.getMapper()));
        xStream.registerConverter((Converter)new XmlArtifactDeserializationRequestConverter(xStream.getMapper()));
        xStream.ignoreUnknownElements();
        return xStream;
    }

    @Override
    public String serialize(Object object) {
        return XStreamClientSerializer.createXStream().toXML(object);
    }

    @Override
    public <T> T deserialize(String xml) {
        return (T)XStreamClientSerializer.createXStream().fromXML(xml);
    }

    private static class TypeAnnotationsMapConverter
    extends MapConverter {
        public TypeAnnotationsMapConverter(Mapper mapper) {
            super(mapper);
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            Map map = (Map)source;
            if (map.isEmpty()) {
                super.marshal(source, writer, context);
                return;
            }
            Map.Entry entry = map.entrySet().iterator().next();
            if (entry.getKey() instanceof Class) {
                if (TypeAnnotation.class.isAssignableFrom((Class)entry.getKey())) {
                    Map typeAnnotationMap = map;
                    LinkedHashMap toTypeAnnotationTransformedMap = new LinkedHashMap();
                    for (Map.Entry e : typeAnnotationMap.entrySet()) {
                        if (!((TypeAnnotation)e.getValue()).isPublic()) continue;
                        toTypeAnnotationTransformedMap.put(new TypeAnnotationEntryKey(((TypeAnnotation)e.getValue()).getName()), e.getValue());
                    }
                    super.marshal(toTypeAnnotationTransformedMap, writer, context);
                }
            } else {
                super.marshal(source, writer, context);
            }
        }

        protected void putCurrentEntryIntoMap(HierarchicalStreamReader reader, UnmarshallingContext context, Map map, Map target) {
            reader.moveDown();
            Class<? extends TypeAnnotation> key = this.readItem(reader, context, map);
            reader.moveUp();
            Object value = null;
            reader.moveDown();
            if (key instanceof TypeAnnotationEntryKey) {
                String typeId = ((TypeAnnotationEntryKey)((Object)key)).getTypeId();
                if (TypeIdAnnotationMapper.TYPE_ANNOTATIONS_MAPPING.containsKey(typeId)) {
                    key = TypeIdAnnotationMapper.TYPE_ANNOTATIONS_MAPPING.get(typeId);
                } else {
                    LOGGER.warn("Unknown typeId:'{}' when unmarshalling TypeAnnotation", (Object)typeId);
                    key = null;
                }
            }
            if (key != null) {
                value = this.readItem(reader, context, map);
            }
            reader.moveUp();
            if (key != null && value != null) {
                target.put(key, value);
            }
        }
    }
}

