/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.persistence;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.mule.tooling.client.api.component.ComponentIdentifier;
import org.mule.tooling.client.api.extension.model.ErrorModel;
import org.mule.tooling.client.api.extension.model.ErrorModelBuilder;
import org.mule.tooling.client.internal.persistence.ErrorModelToIdentifierSerializer;
import org.mule.tooling.client.internal.util.Pair;

class ErrorModelSerializerDelegate {
    private static final String ERROR = "error";
    private static final String PARENT = "parent";
    private static final String EMPTY = "";
    private static final String HANDLEABLE = "handleable";
    private Map<String, ErrorModel> errorModelRespository;

    ErrorModelSerializerDelegate(Map<String, ErrorModel> errorModelRespository) {
        this.errorModelRespository = errorModelRespository;
    }

    void writeErrors(Set<ErrorModel> errorModels, JsonWriter out) throws IOException {
        Set<ErrorModel> models = this.flatenizeErrors(errorModels);
        out.name("errors");
        out.beginArray();
        for (ErrorModel errorModel : models) {
            this.writeError(out, errorModel);
        }
        out.endArray();
    }

    private void writeError(JsonWriter out, ErrorModel errorModel) throws IOException {
        out.beginObject();
        out.name(ERROR).value(ErrorModelToIdentifierSerializer.serialize(errorModel));
        if (errorModel.getParent().isPresent()) {
            out.name(PARENT).value(ErrorModelToIdentifierSerializer.serialize(errorModel.getParent().get()));
        }
        if (errorModel.getHandleable().isEnabled()) {
            out.name(HANDLEABLE).value(errorModel.getHandleable().get().booleanValue());
        }
        out.endObject();
    }

    public Set<ErrorModel> getErrors() {
        HashSet<ErrorModel> errorModels = new HashSet<ErrorModel>();
        errorModels.addAll(this.errorModelRespository.values());
        return errorModels;
    }

    private Set<ErrorModel> flatenizeErrors(Set<ErrorModel> errorModels) {
        HashSet<ErrorModel> models = new HashSet<ErrorModel>();
        errorModels.forEach(model -> {
            models.add((ErrorModel)model);
            Optional<ErrorModel> parent = model.getParent();
            while (parent.isPresent()) {
                ErrorModel parentModel = parent.get();
                models.add(parentModel);
                parent = parentModel.getParent();
            }
        });
        return models;
    }

    Map<String, ErrorModel> parseErrors(JsonArray errors) {
        HashMap buildingErrors = new HashMap();
        errors.iterator().forEachRemaining(element -> {
            JsonObject error = element.getAsJsonObject();
            String anError = error.get(ERROR).getAsString();
            String parentError = EMPTY;
            if (error.has(PARENT)) {
                parentError = error.get(PARENT).getAsString();
            }
            ErrorModelBuilder errorModelBuilder = ErrorModelBuilder.newError(ComponentIdentifier.buildFromStringRepresentation(anError));
            if (error.has(HANDLEABLE)) {
                errorModelBuilder.handleable(error.get(HANDLEABLE).getAsBoolean());
            }
            buildingErrors.put(anError, new Pair<String, ErrorModelBuilder>(parentError, errorModelBuilder));
        });
        buildingErrors.keySet().forEach(key -> this.buildError((String)key, buildingErrors, this.errorModelRespository));
        return this.errorModelRespository;
    }

    private ErrorModel buildError(String errorIdentifier, Map<String, Pair<String, ErrorModelBuilder>> buildingErrors, Map<String, ErrorModel> builtErrorModels) {
        if (builtErrorModels.containsKey(errorIdentifier)) {
            return builtErrorModels.get(errorIdentifier);
        }
        Pair<String, ErrorModelBuilder> builderPair = buildingErrors.get(errorIdentifier);
        if (builderPair != null) {
            String parentError = builderPair.getFirst();
            ErrorModel errorModel = builderPair.getSecond().withParent(this.buildError(parentError, buildingErrors, builtErrorModels)).build();
            builtErrorModels.put(errorIdentifier, errorModel);
            return errorModel;
        }
        if (StringUtils.isBlank((CharSequence)errorIdentifier)) {
            return null;
        }
        ComponentIdentifier identifier = ComponentIdentifier.buildFromStringRepresentation(errorIdentifier);
        return this.buildSimpleError(identifier, builtErrorModels);
    }

    private ErrorModel buildSimpleError(ComponentIdentifier identifier, Map<String, ErrorModel> builtErrors) {
        ErrorModel errorModel = ErrorModelBuilder.newError(identifier).build();
        builtErrors.put(identifier.toString(), errorModel);
        return errorModel;
    }
}

