/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.configuration.ssl;

import java.io.File;
import java.util.Objects;
import org.apache.commons.lang3.ClassUtils;
import org.mule.tooling.client.api.configuration.ssl.KeyStoreConfig;

public class ImmutableKeyStoreConfig
implements KeyStoreConfig {
    private final File keyStoreFile;
    private final String keyStorePassword;

    public ImmutableKeyStoreConfig(File keyStoreFile, String keyStorePassword) {
        Objects.requireNonNull(keyStoreFile, "keyStoreFile cannot be null");
        Objects.requireNonNull(keyStorePassword, "keyStorePassword cannot be null");
        this.keyStoreFile = keyStoreFile;
        this.keyStorePassword = keyStorePassword;
    }

    @Override
    public File getKeyStoreFile() {
        return this.keyStoreFile;
    }

    @Override
    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public String toString() {
        return String.format("%s{keyStoreFile=%s, keyStorePassword=%s}", ClassUtils.getShortClassName(this.getClass()), this.keyStoreFile.getAbsolutePath(), "****");
    }
}

