/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.MapSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mule.metadata.api.model.impl.DefaultArrayType;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.internal.serialization.DefaultArrayTypeSerializer;
import org.mule.tooling.client.internal.serialization.KryoFactory;
import org.mule.tooling.client.internal.serialization.Serializer;
import org.mule.tooling.client.internal.serialization.mapping.TypeAnnotationMapWriter;

public final class KryoClientSerializer
implements Serializer {
    public static String NAME = "kryo";
    private ClassLoader sourceClassLoader;
    private ClassLoader targetClassLoader;
    private List<Class> typeAnnotationsNotSupportedByToolingRuntimeClient;

    public KryoClientSerializer(ClassLoader sourceClassLoader, ClassLoader targetClassLoader) {
        this.sourceClassLoader = sourceClassLoader;
        this.targetClassLoader = targetClassLoader;
        this.typeAnnotationsNotSupportedByToolingRuntimeClient = Collections.synchronizedList(new ArrayList());
    }

    private static Kryo createKryo(ClassLoader sourceClassLoader, ClassLoader targetClassLoader, List<Class> typeAnnotationsSupportedByImplementation) {
        Kryo kryo = KryoFactory.createKryo(targetClassLoader);
        kryo.setClassLoader(sourceClassLoader);
        kryo.addDefaultSerializer(DefaultArrayType.class, new DefaultArrayTypeSerializer());
        kryo.register(LinkedHashMap.class, (com.esotericsoftware.kryo.Serializer)new TypeAnnotationsMapSerializer(targetClassLoader, typeAnnotationsSupportedByImplementation));
        return kryo;
    }

    @Override
    public String serialize(Object object) {
        return this.doSerialize((kryo, objectToBeSerialized, output) -> kryo.writeClassAndObject(output, objectToBeSerialized), object);
    }

    @Override
    public <T> T deserialize(String content) {
        try (Input input = new Input((InputStream)new ByteArrayInputStream(Base64.getDecoder().decode(content)));){
            Object object = KryoClientSerializer.createKryo(this.sourceClassLoader, this.targetClassLoader, this.typeAnnotationsNotSupportedByToolingRuntimeClient).readClassAndObject(input);
            return (T)object;
        }
    }

    public String safeSerialize(Object object) {
        return this.doSerialize((kryo, objectToBeSerialized, output) -> kryo.writeObject(output, objectToBeSerialized), object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String doSerialize(KryoWriteTask writeTask, Object object) {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            try (Output output = new Output((OutputStream)byteArrayOutputStream);){
                writeTask.write(KryoClientSerializer.createKryo(this.sourceClassLoader, this.targetClassLoader, this.typeAnnotationsNotSupportedByToolingRuntimeClient), object, output);
            }
            String string = Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
            return string;
        }
        catch (IOException e) {
            throw new ToolingException("Error while creating object from serialization", e);
        }
    }

    private static class TypeAnnotationsMapSerializer
    extends MapSerializer {
        private TypeAnnotationMapWriter typeAnnotationMapWriter;

        public TypeAnnotationsMapSerializer(ClassLoader targetClassLoader, List<Class> typeAnnotationsNotSupportedByToolingRuntimeClient) {
            this.typeAnnotationMapWriter = new TypeAnnotationMapWriter(targetClassLoader, typeAnnotationsNotSupportedByToolingRuntimeClient);
        }

        public void write(Kryo kryo, Output output, Map map) {
            super.write(kryo, output, this.typeAnnotationMapWriter.write(map));
        }
    }

    private static interface KryoWriteTask {
        public void write(Kryo var1, Object var2, Output var3);
    }
}

