/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.datasense;

import org.mule.tooling.client.api.component.location.Location;

import java.util.Map;

/**
 * Immutable implementation of {@link org.mule.tooling.client.api.datasense.MetadataCache.MetadataCacheKeyInfo}.
 *
 * @since 1.0
 */
public class ImmutableMetadataCacheKeyInfo implements MetadataCache.MetadataCacheKeyInfo {

  private String componentId;
  private String location;
  private Long timestamp;
  private Map<String, String> toolingArtifactProperties;

  /**
   * Creates an instance of this object.
   *
   * @param componentId {@code doc:id} on xml to which the key metadata is about to be resolved.
   * @param location {@link String} representation for {@link Location} on Mule configuration to which the key metadata is about to be resolved. If needed use {@link Location#builderFromStringRepresentation(String)}
   *         to get more detailed information about it.
   * @param timestamp the {@code timestamp} on Mule configuration element to which the key metadata is about to be resolved.
   * @param toolingArtifactProperties {@link Map} of tooling artifact properties for the {@link org.mule.tooling.client.api.artifact.ToolingArtifact}.
   */
  public ImmutableMetadataCacheKeyInfo(String componentId, String location, Long timestamp,
                                       Map<String, String> toolingArtifactProperties) {
    this.componentId = componentId;
    this.location = location;
    this.timestamp = timestamp;
    this.toolingArtifactProperties = toolingArtifactProperties;
  }

  @Override
  public String getComponentId() {
    return componentId;
  }

  @Override
  public String getLocation() {
    return location;
  }

  @Override
  public Long getTimestamp() {
    return timestamp;
  }

  @Override
  public Map<String, String> getToolingArtifactProperties() {
    return toolingArtifactProperties;
  }

}
