/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.extension.model.parameter;

import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.api.extension.model.DisplayModel;
import org.mule.tooling.client.api.extension.model.ExpressionSupport;
import org.mule.tooling.client.api.extension.model.LayoutModel;
import org.mule.tooling.client.api.extension.model.ParameterDslConfiguration;
import org.mule.tooling.client.api.extension.model.StereotypeModel;
import org.mule.tooling.client.api.extension.model.deprecated.DeprecationModel;
import org.mule.tooling.client.api.extension.model.metadata.MetadataKeyPartModel;
import org.mule.tooling.client.api.extension.model.parameter.ParameterRole;
import org.mule.tooling.client.api.extension.model.property.DefaultImplementingTypeModel;
import org.mule.tooling.client.api.extension.model.property.InfrastructureParameterModel;
import org.mule.tooling.client.api.extension.model.property.QNameModel;
import org.mule.tooling.client.api.extension.model.value.ValueProviderModel;
import org.mule.tooling.client.api.feature.Feature;

public final class ParameterModel {
    private String name;
    private String description;
    private DisplayModel displayModel;
    private MetadataType type;
    private boolean hasDynamicType;
    private boolean required;
    private boolean isConfigOverride;
    private ExpressionSupport expressionSupport;
    private Object defaultValue;
    private ParameterRole role;
    private ParameterDslConfiguration dslConfiguration;
    private LayoutModel layoutModel;
    private ValueProviderModel valueProviderModel;
    private List<StereotypeModel> allowedStereotypes;
    private Feature<DeprecationModel> deprecationModel;
    private MetadataKeyPartModel metadataKeyPartModel;
    private QNameModel qNameModel;
    private InfrastructureParameterModel infrastructureParameterModel;
    private DefaultImplementingTypeModel defaultImplementingTypeModel;

    private ParameterModel() {
    }

    public ParameterModel(String name, String description, DisplayModel displayModel, MetadataType type, boolean hasDynamicType, boolean required, boolean isConfigOverride, ExpressionSupport expressionSupport, Object defaultValue, ParameterRole role, ParameterDslConfiguration dslConfiguration, LayoutModel layoutModel, MetadataKeyPartModel metadataKeyPartModel, QNameModel qNameModel, InfrastructureParameterModel infrastructureParameterModel, DefaultImplementingTypeModel defaultImplementingTypeModel, ValueProviderModel valueProviderModel, List<StereotypeModel> allowedStereotypes, DeprecationModel deprecationModel) {
        this.name = name;
        this.description = description;
        this.displayModel = displayModel;
        this.type = type;
        this.hasDynamicType = hasDynamicType;
        this.required = required;
        this.isConfigOverride = isConfigOverride;
        this.expressionSupport = expressionSupport;
        this.defaultValue = defaultValue;
        this.role = role;
        this.dslConfiguration = dslConfiguration;
        this.layoutModel = layoutModel;
        this.metadataKeyPartModel = metadataKeyPartModel;
        this.qNameModel = qNameModel;
        this.infrastructureParameterModel = infrastructureParameterModel;
        this.defaultImplementingTypeModel = defaultImplementingTypeModel;
        this.valueProviderModel = valueProviderModel;
        this.allowedStereotypes = allowedStereotypes;
        this.deprecationModel = Feature.enabled(deprecationModel);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Optional<DisplayModel> getDisplayModel() {
        return Optional.ofNullable(this.displayModel);
    }

    public MetadataType getType() {
        return this.type;
    }

    public boolean hasDynamicType() {
        return this.hasDynamicType;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isOverrideFromConfig() {
        return this.isConfigOverride;
    }

    public ExpressionSupport getExpressionSupport() {
        return this.expressionSupport;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public ParameterDslConfiguration getDslConfiguration() {
        return this.dslConfiguration;
    }

    public ParameterRole getRole() {
        return this.role;
    }

    public Optional<LayoutModel> getLayoutModel() {
        return Optional.ofNullable(this.layoutModel);
    }

    public Optional<MetadataKeyPartModel> getMetadataKeyPartModel() {
        return Optional.ofNullable(this.metadataKeyPartModel);
    }

    public Optional<QNameModel> getQNameModel() {
        return Optional.ofNullable(this.qNameModel);
    }

    public Optional<InfrastructureParameterModel> getInfrastructureParameterModel() {
        return Optional.ofNullable(this.infrastructureParameterModel);
    }

    public Optional<DefaultImplementingTypeModel> getDefaultImplementingTypeModel() {
        return Optional.ofNullable(this.defaultImplementingTypeModel);
    }

    public Optional<ValueProviderModel> getValueProviderModel() {
        return Optional.ofNullable(this.valueProviderModel);
    }

    public List<StereotypeModel> getAllowedStereotypes() {
        return this.allowedStereotypes;
    }

    public Feature<DeprecationModel> getDeprecationModel() {
        if (this.deprecationModel == null) {
            this.deprecationModel = Feature.disabled();
        }
        return this.deprecationModel;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        return this.getClass().isInstance(obj) && this.name.equals(((ParameterModel)obj).getName());
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

