/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.extension.model.property;

import org.mule.metadata.api.model.MetadataType;

/**
 * Declares the default {@code Type} that will be instantiated for this {@link org.mule.tooling.client.api.extension.model.parameter.ParameterModel}
 * if no instance is provided as a value.
 *
 * @since 1.0
 */
public class DefaultImplementingTypeModel {

  private final MetadataType defaultType;

  public DefaultImplementingTypeModel(MetadataType defaultType) {
    this.defaultType = defaultType;
  }

  /**
   * @return the default {@link MetadataType} to be used when creating the default instance for
   * the associated {@link org.mule.tooling.client.api.extension.model.parameter.ParameterModel}
   */
  public MetadataType value() {
    return defaultType;
  }

}
