/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.component.location;

import java.util.Objects;

/**
 * The location of the components in the configuration file.
 */
public class SourceCodeLocation {

  private String fileName;
  private Integer startLine;
  private Integer startColumn;

  public SourceCodeLocation(String fileName, Integer startLine, Integer startColumn) {
    this.fileName = fileName;
    this.startLine = startLine;
    this.startColumn = startColumn;
  }

  /**
   * @return the file which contains the component
   */
  public String getFileName() {
    return fileName;
  }

  /**
   * @return the line in which the component starts within the file.
   */
  public Integer getStartLine() {
    return startLine;
  }

  /**
   * @return the column in which the component starts within the file.
   */
  public Integer getStartColumn() {
    return startColumn;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SourceCodeLocation that = (SourceCodeLocation) o;
    return Objects.equals(getFileName(), that.getFileName()) &&
        Objects.equals(getStartLine(), that.getStartLine()) &&
        Objects.equals(getStartColumn(), that.getStartColumn());
  }

  @Override
  public int hashCode() {
    return Objects.hash(getFileName(), getStartLine(), getStartColumn());
  }
}
