/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.configuration.agent.proxy;

/**
 * HTTP proxy configuration for making HTTP and HTTPS requests.
 *
 * @since 1.1
 */
public interface ProxyConfig {

  /**
   * @return a {@link ProxyConfigBuilder}.
   */
  static ProxyConfigBuilder builder() {
    return new ProxyConfigBuilder();
  }

  /**
   * @return the HTTP proxy host
   */
  String getHost();

  /**
   * @return the HTTP proxy port
   */
  Integer getPort();

}
