/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.message.history;

import java.util.Map;

/**
 * Represents a component notification from an application.
 *
 * @since 1.0
 */
public interface Notification {

  /**
   * @return The application that is the source of the notification.
   */
  String getApplication();

  /**
   * @return The time at which the notification was produced.
   */
  long getTimestamp();

  /**
   * @return The action represented by the notification.
   */
  NotificationAction getAction();

  /**
   * @return The name of the component of the notification.
   */
  String getComponent();

  /**
   * @return The message at the moment the notification was sent.
   */
  Message getMessage();

  /**
   * @return The component Mule path.
   */
  String getComponentPath();

  /**
   * @return The message correlation ID.
   */
  String getCorrelationId();

  /**
   * @return Mule Event variables.
   */
  Map<String, TypedValue> getVariables();

}
