/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.metadata;

import org.mule.tooling.client.api.types.UnknownType;

/**
 * Enumerates all the components that can be retrieved in a {@link MetadataResult}.
 *
 * @since 1.0
 */
public class MetadataComponent extends UnknownType {

  private boolean outputAttributes = false;
  private boolean outputPayload = false;
  private boolean input = false;
  private boolean component = false;
  private boolean entity = false;
  private boolean keys = false;

  // Just needed in order to serialize this object
  private MetadataComponent() {}

  public MetadataComponent(String name) {
    super(name);
  }

  public static MetadataComponent outputAttributesMetadataComponent(String value) {
    MetadataComponent component = new MetadataComponent(value);
    component.outputAttributes = true;
    return component;
  }

  public static MetadataComponent outputPayloadMetadataComponent(String value) {
    MetadataComponent component = new MetadataComponent(value);
    component.outputPayload = true;
    return component;
  }

  public static MetadataComponent keysMetadataComponent(String value) {
    MetadataComponent component = new MetadataComponent(value);
    component.keys = true;
    return component;
  }

  public static MetadataComponent entityMetadataComponent(String value) {
    MetadataComponent component = new MetadataComponent(value);
    component.entity = true;
    return component;
  }

  public static MetadataComponent inputMetadataComponent(String value) {
    MetadataComponent component = new MetadataComponent(value);
    component.input = true;
    return component;
  }

  public static MetadataComponent componentMetadataComponent(String value) {
    MetadataComponent component = new MetadataComponent(value);
    component.component = true;
    return component;
  }

  /**
   * @return {@code true} if it is component that retrieves metadata about the keys.
   */
  public boolean isKeys() {
    return keys;
  }

  /**
   * @return {@code true} if it is component that retrieves metadata about DSQL entities.
   */
  public boolean isEntity() {
    return entity;
  }

  /**
   * @return {@code true} if it is component that retrieves metadata for an Operation or a Source.
   */
  public boolean isComponent() {
    return component;
  }

  /**
   * @return {@code true} if it is component that retrieves metadata for an Operation or Source parameter.
   */
  public boolean isInput() {
    return input;
  }

  /**
   * @return {@code true} if it is component that retrieves metadata for an Operation or Source output attributes type.
   */
  public boolean isOutputAttributes() {
    return outputAttributes;
  }

  /**
   * @return {@code true} if it is component that retrieves metadata for an Operation or Source output type.
   */
  public boolean isOutputPayload() {
    return outputPayload;
  }

}
