/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.extension.model;

import static org.apache.commons.lang3.builder.EqualsBuilder.reflectionEquals;
import static org.apache.commons.lang3.builder.HashCodeBuilder.reflectionHashCode;
import org.mule.metadata.api.model.MetadataType;

import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * Represents the output of a component.
 *
 * @since 1.0
 */
public class OutputModel {

  private String description;
  private MetadataType type;
  private boolean dynamicType;

  // Just needed in order to serialize this object
  private OutputModel() {}

  public OutputModel(String description, MetadataType type, boolean dynamicType) {
    this.description = description;
    this.type = type;
    this.dynamicType = dynamicType;
  }

  public String getDescription() {
    return this.description;
  }

  public MetadataType getType() {
    return type;
  }

  public boolean hasDynamicType() {
    return dynamicType;
  }

  public int hashCode() {
    return reflectionHashCode(this);
  }

  public boolean equals(Object obj) {
    return reflectionEquals(this, obj);
  }

  public String toString() {
    return ToStringBuilder.reflectionToString(this);
  }

}
