/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.extension.model.construct;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.mule.tooling.client.api.extension.model.ComponentModel;
import org.mule.tooling.client.api.extension.model.DisplayModel;
import org.mule.tooling.client.api.extension.model.ErrorModel;
import org.mule.tooling.client.api.extension.model.StereotypeModel;
import org.mule.tooling.client.api.extension.model.connection.ConnectionProviderModel;
import org.mule.tooling.client.api.extension.model.deprecated.DeprecationModel;
import org.mule.tooling.client.api.extension.model.nested.NestableElementModel;
import org.mule.tooling.client.api.extension.model.parameter.ParameterGroupModel;
import org.mule.tooling.client.api.feature.Feature;

public class ConstructModel
implements ComponentModel {
    private String name;
    private String description;
    private List<ParameterGroupModel> parameterGroupModels;
    private DisplayModel displayModel;
    private StereotypeModel stereotype;
    private List<? extends NestableElementModel> nestedComponents;
    private boolean allowsTopLevelDefinition;
    private Set<ErrorModel> errorModels;
    private Feature<DeprecationModel> deprecationModel;

    public ConstructModel(String name, String description, List<ParameterGroupModel> parameterGroupModels, DisplayModel displayModel, StereotypeModel stereotype, List<? extends NestableElementModel> nestedComponents, boolean allowsTopLevelDefinition, Set<ErrorModel> errorModels, DeprecationModel deprecationModel) {
        this.name = name;
        this.description = description;
        this.parameterGroupModels = parameterGroupModels;
        this.displayModel = displayModel;
        this.stereotype = stereotype;
        this.nestedComponents = nestedComponents;
        this.allowsTopLevelDefinition = allowsTopLevelDefinition;
        this.errorModels = errorModels;
        this.deprecationModel = Feature.enabled(deprecationModel);
    }

    public boolean allowsTopLevelDeclaration() {
        return this.allowsTopLevelDefinition;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<ParameterGroupModel> getParameterGroupModels() {
        return this.parameterGroupModels;
    }

    @Override
    public Optional<DisplayModel> getDisplayModel() {
        return Optional.ofNullable(this.displayModel);
    }

    @Override
    public StereotypeModel getStereotype() {
        return this.stereotype;
    }

    @Override
    public List<? extends NestableElementModel> getNestedComponents() {
        return this.nestedComponents;
    }

    public boolean isAllowsTopLevelDefinition() {
        return this.allowsTopLevelDefinition;
    }

    @Override
    public Set<ErrorModel> getErrorModels() {
        return this.errorModels;
    }

    public Feature<DeprecationModel> getDeprecationModel() {
        if (this.deprecationModel == null) {
            this.deprecationModel = Feature.disabled();
        }
        return this.deprecationModel;
    }

    public Optional<ParameterGroupModel> getParameterGroupModel(String name) {
        return this.parameterGroupModels.stream().filter(model -> model.getName().equals(name)).findFirst();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        return this.getClass().isInstance(obj) && this.name.equals(((ConnectionProviderModel)obj).getName());
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

