/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.extension.persistence;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.metadata.persistence.SerializationContext;
import org.mule.metadata.persistence.type.adapter.OptionalTypeAdapterFactory;
import org.mule.tooling.client.api.extension.model.ExtensionModel;
import org.mule.tooling.client.api.extension.model.ImportedTypeModel;
import org.mule.tooling.client.internal.persistence.ExtensionModelTypeAdapter;
import org.mule.tooling.client.internal.persistence.MetadataTypeAdapterFactory;
import org.mule.tooling.client.internal.persistence.NestableElementModelTypeAdapterFactory;
import org.mule.tooling.client.internal.persistence.RestrictedTypesObjectTypeReferenceHandler;

public final class ExtensionModelJsonSerializer {
    private final boolean prettyPrint;
    private Set<ObjectType> registeredTypes = Collections.emptySet();
    private Set<ObjectType> importedTypes = Collections.emptySet();

    public ExtensionModelJsonSerializer() {
        this(false);
    }

    public ExtensionModelJsonSerializer(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    private Gson buildGson() {
        final HashMap errorModelRepository = new HashMap();
        final SerializationContext serializationContext = new SerializationContext();
        final Gson gsonDelegate = this.gsonBuilder(serializationContext, this.prettyPrint).create();
        return this.gsonBuilder(serializationContext, this.prettyPrint).registerTypeAdapterFactory(new TypeAdapterFactory(){

            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
                if (ExtensionModel.class.isAssignableFrom(type.getRawType())) {
                    return new ExtensionModelTypeAdapter(gsonDelegate, serializationContext, errorModelRepository);
                }
                return null;
            }
        }).create();
    }

    private GsonBuilder gsonBuilder(SerializationContext serializationContext, boolean prettyPrint) {
        Set<String> registeredTypeIds = this.registeredTypes.stream().map(JavaTypeUtils::getId).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        this.importedTypes.forEach(type -> {
            JavaTypeUtils.getId((MetadataType)type).ifPresent(registeredTypeIds::add);
            serializationContext.registerObjectType(type);
        });
        RestrictedTypesObjectTypeReferenceHandler referenceHandler = new RestrictedTypesObjectTypeReferenceHandler(serializationContext, registeredTypeIds);
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new MetadataTypeAdapterFactory(referenceHandler)).registerTypeAdapterFactory((TypeAdapterFactory)new OptionalTypeAdapterFactory()).registerTypeAdapterFactory((TypeAdapterFactory)new NestableElementModelTypeAdapterFactory());
        if (prettyPrint) {
            gsonBuilder.setPrettyPrinting();
        }
        return gsonBuilder;
    }

    public String serialize(ExtensionModel extensionModel) {
        this.registeredTypes = extensionModel.getTypes();
        this.importedTypes = extensionModel.getImportedTypes().stream().map(ImportedTypeModel::getImportedType).collect(Collectors.toSet());
        return this.buildGson().toJson((Object)extensionModel);
    }

    public String serializeList(List<ExtensionModel> extensionModelList) {
        return this.buildGson().toJson(extensionModelList);
    }

    public ExtensionModel deserialize(String extensionModel) {
        return (ExtensionModel)this.buildGson().fromJson(extensionModel, ExtensionModel.class);
    }

    public List<ExtensionModel> deserializeList(String extensionModelList) {
        return (List)this.buildGson().fromJson(extensionModelList, new TypeToken<List<ExtensionModel>>(){}.getType());
    }
}

