/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.metadata;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.tooling.client.api.metadata.MetadataKey;

public final class MetadataKeysContainer {
    private Map<String, Set<MetadataKey>> keyMap;

    public MetadataKeysContainer(Map<String, Set<MetadataKey>> keyMap) {
        this.keyMap = Collections.unmodifiableMap(keyMap);
    }

    public Optional<Set<MetadataKey>> getKeys(String categoryName) {
        Set<MetadataKey> keys = this.keyMap.get(categoryName);
        return keys == null ? Optional.empty() : Optional.of(Collections.unmodifiableSet(keys));
    }

    public Set<String> getCategories() {
        return Collections.unmodifiableSet(this.keyMap.keySet());
    }

    public Map<String, Set<MetadataKey>> getKeysByCategory() {
        return this.keyMap;
    }
}

