/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.metadata.type;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.tooling.client.api.extension.model.ExtensionModel;
import org.mule.tooling.client.api.metadata.type.ObjectTypeHierarchy;
import org.mule.tooling.client.api.metadata.type.SubTypeMapping;
import org.mule.tooling.client.internal.metadata.type.TypeRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataTypeHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataTypeHelper.class);

    private MetadataTypeHelper() {
    }

    public static List<ObjectTypeHierarchy> getObjectTypeHierarchies(Set<ExtensionModel> extensions) {
        TypeRepository typeRepository = new TypeRepository(extensions);
        return typeRepository.getAllBaseTypes().stream().map(baseType -> {
            ObjectTypeHierarchy objectTypeHierarchy = new ObjectTypeHierarchy();
            objectTypeHierarchy.setType((ObjectType)baseType);
            Optional<String> declaringExtension = typeRepository.getDeclaringExtension((MetadataType)baseType);
            if (declaringExtension.isPresent()) {
                objectTypeHierarchy.setExtensionName(declaringExtension.get());
                objectTypeHierarchy.setSubTypeMappings(typeRepository.getSubTypes((ObjectType)baseType).stream().map(subType -> {
                    SubTypeMapping subTypeMapping = new SubTypeMapping();
                    subTypeMapping.setObjectType((ObjectType)subType);
                    subTypeMapping.setExtensionName(typeRepository.getDeclaringExtension((MetadataType)subType).get());
                    return subTypeMapping;
                }).collect(Collectors.toSet()));
            } else {
                LOGGER.warn(String.format("Ignoring baseType: '%s' as it is not defined by an extension in its type catalog", MetadataTypeUtils.getTypeId((MetadataType)baseType).orElse(baseType.toString())));
            }
            return objectTypeHierarchy;
        }).filter(objectTypeHierarchy -> !objectTypeHierarchy.getSubTypeMappings().isEmpty()).collect(Collectors.toList());
    }
}

