/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.serialization;

import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.util.IdentityObjectIntMap;
import com.esotericsoftware.kryo.util.Util;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.objenesis.instantiator.ObjectInstantiator;
import org.objenesis.strategy.InstantiatorStrategy;

public class DefaultInstantiatorStrategyWithCache
implements InstantiatorStrategy {
    private InstantiatorStrategy fallbackStrategy;
    private IdentityObjectIntMap<Class> fallbackClassMemoize = new IdentityObjectIntMap();

    public DefaultInstantiatorStrategyWithCache() {
    }

    public DefaultInstantiatorStrategyWithCache(InstantiatorStrategy fallbackStrategy) {
        this.fallbackStrategy = fallbackStrategy;
    }

    public void setFallbackInstantiatorStrategy(InstantiatorStrategy fallbackStrategy) {
        this.fallbackStrategy = fallbackStrategy;
    }

    public InstantiatorStrategy getFallbackInstantiatorStrategy() {
        return this.fallbackStrategy;
    }

    public ObjectInstantiator newInstantiatorOf(final Class type) {
        if (!this.fallbackClassMemoize.containsKey((Object)type)) {
            try {
                Constructor ctor;
                try {
                    ctor = type.getConstructor(null);
                }
                catch (Exception ex) {
                    ctor = type.getDeclaredConstructor(null);
                    ctor.setAccessible(true);
                }
                final Constructor constructor = ctor;
                return new ObjectInstantiator(){

                    public Object newInstance() {
                        try {
                            return constructor.newInstance(new Object[0]);
                        }
                        catch (Exception ex) {
                            throw new KryoException("Error constructing instance of class: " + Util.className((Class)type), (Throwable)ex);
                        }
                    }
                };
            }
            catch (Exception ctor) {
                // empty catch block
            }
        }
        if (this.fallbackStrategy == null) {
            if (type.isMemberClass() && !Modifier.isStatic(type.getModifiers())) {
                throw new KryoException("Class cannot be created (non-static member class): " + Util.className((Class)type));
            }
            StringBuilder errorMessageSb = new StringBuilder("Class cannot be created (missing no-arg constructor): " + Util.className((Class)type));
            if (type.getSimpleName().equals("")) {
                errorMessageSb.append("\n\tThis is an anonymous class, which is not serializable by default in Kryo. Possible solutions: ").append("1. Remove uses of anonymous classes, including double brace initialization, from the containing ").append("class. This is the safest solution, as anonymous classes don't have predictable names for serialization.").append("\n\t2. Register a FieldSerializer for the containing class and call ").append("FieldSerializer#setIgnoreSyntheticFields(false) on it. This is not safe but may be sufficient temporarily. ").append("Use at your own risk.");
            }
            throw new KryoException(errorMessageSb.toString());
        }
        this.fallbackClassMemoize.put((Object)type, type.hashCode());
        return this.fallbackStrategy.newInstantiatorOf(type);
    }
}

