/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.el;

import static java.util.Collections.emptyList;
import static java.util.Collections.unmodifiableList;
import static org.mule.tooling.client.api.el.Severity.WARNING;

import java.util.List;

/**
 * Represents the result of an expression validation.
 *
 * @since 1.0
 */
public class ValidationResult {

  private List<ValidationMessage> messages = emptyList();

  public ValidationResult(List<ValidationMessage> messages) {
    this.messages = unmodifiableList(messages);
  }

  /**
   * @return a list of all {@link ValidationMessage}s found or an empty list if no relevant data is present
   */
  public List<ValidationMessage> getMessages() {
    return messages;
  }

  /**
   * @return {@code true} if only {@link Severity#WARNING} are present in list of messages or no messages are present at all.
   */
  public boolean isSuccess() {
    return messages.isEmpty() || messages.stream().allMatch(validationMessage -> validationMessage.getSeverity().equals(WARNING));
  }

}
