/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.feature;

import java.util.function.Consumer;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.mule.tooling.client.api.exception.FeatureNotSupportedException;

public class Feature<T> {
    private T value;
    private boolean enabled;

    private Feature(T value, boolean enabled) {
        this.value = value;
        this.enabled = enabled;
    }

    public static <T> Feature<T> disabled() {
        return new Feature<Object>(null, false);
    }

    public static <T> Feature<T> enabled(T value) {
        return new Feature<T>(value, true);
    }

    public T get() {
        if (!this.isEnabled()) {
            throw new FeatureNotSupportedException("Feature is not supported for this Mule Tooling API version");
        }
        return this.value;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void ifEnabled(Consumer<T> consumer) {
        if (this.isEnabled()) {
            consumer.accept(this.value);
        }
    }

    public T orElse(T defaultValue) {
        return this.isEnabled() ? this.value : defaultValue;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Feature)) {
            return false;
        }
        Feature other = (Feature)o;
        if (!other.isEnabled() && !this.isEnabled()) {
            return true;
        }
        if (!other.isEnabled() || !this.isEnabled()) {
            return false;
        }
        if (this.value == null) {
            return other.value == null;
        }
        return this.value.equals(other.value);
    }
}

