/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.datasense.storage;

import org.mule.tooling.client.api.cache.CacheStorage;

/**
 * Defines the storage mechanism used to build a MetadataCache.
 * The cache will be used to store resolved dynamic metadata and avoid computing it multiple times.
 * </p>
 * In case an specific implementation needs to serialize the data prior to storage, they should keep a reference of the
 * {@link MetadataCacheStorageSerializer}s available in the {@link MetadataCacheStorageFactoryContext} when executing
 * {@link MetadataCacheStorageFactory#createMetadataCache(MetadataCacheStorageFactoryContext)};
 *
 * In case serializers are used, implementations should follow this rule:
 *
 * If a value was serialized to be stored {@link MetadataCacheStorage#put(String, Object)},
 * it should be deserialized when returned {@link MetadataCacheStorage#get(String)}
 * That means that, weather or not the value was serialized, the following should always be true:
 * <code>
 *    storage.put("KEY", object);
 *    Object retrievedObject = storage.get("KEY").get();
 *    assert object.getClass().isAssignableFrom(retrievedObject.class) == true
 * </code>
 *
 * @since 1.2.2, 1.3.0
 */
public interface MetadataCacheStorage extends CacheStorage {

}
