/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.connectivity;

/**
 * An {@code ErrorType} describes an type of error that may be thrown by a mule component.
 *
 * The error type has a string representation {@see getIdentifier} which is used directly by the user in the mule configuration.
 *
 * Every error belongs to a namespace {@see getNamespace} in order to avoid collisions of error with the same string
 * representation but that belong to different namespace {@see getNamespace}.
 *
 * Error types may be an specialization of a more general error type in which case the {@code getParentErrorType} should return
 * the more general error type. This is used when doing error type matching within error handlers so when selecting the general
 * error type for error handling it will also handle the more specialized error types.
 *
 * @since 1.0
 *
 * @deprecated since 1.4 Use {@link org.mule.tooling.client.api.error.ErrorType} instead.
 */
@Deprecated
public class ErrorType {

  private String identifier;
  private String namespace;
  private ErrorType parent;

  private ErrorType() {}

  public ErrorType(String identifier, String namespace, ErrorType parent) {
    this.identifier = identifier;
    this.namespace = namespace;
    this.parent = parent;
  }

  public String getIdentifier() {
    return identifier;
  }

  public String getNamespace() {
    return namespace;
  }

  public ErrorType getParentErrorType() {
    return parent;
  }

}
