/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.datasense.storage;

import org.mule.api.annotation.NoImplement;
import org.mule.tooling.client.api.cache.CacheStorageFactoryContext;

/**
 * Context with information used to build a {@link MetadataCacheStorage} provided to a {@link MetadataCacheStorageFactory}.
 *
 * @since 1.2.2, 1.3.0
 */
@NoImplement
public interface MetadataCacheStorageFactoryContext extends CacheStorageFactoryContext {

  /**
   * @return a {@link MetadataCacheStorageSerializer} that should be used to serialize and deserialize values used in the cache in
   *         case is needed.
   */
  MetadataCacheStorageSerializer getValueSerializer();

}
