/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.exception;

import org.mule.api.annotation.NoExtend;

/**
 * Exception to be thrown whenever a {@link org.mule.tooling.client.api.artifact.ToolingArtifact} is fetched and no longer present
 * in the cache.
 *
 * @since 1.0
 */
@NoExtend
public class ToolingArtifactNotFoundException extends ToolingException {

  public ToolingArtifactNotFoundException(String message) {
    super(message);
  }

}
