/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.extension.model;

import static org.apache.commons.lang3.builder.EqualsBuilder.reflectionEquals;
import static org.apache.commons.lang3.builder.HashCodeBuilder.reflectionHashCode;
import static org.mule.tooling.client.internal.util.Preconditions.checkArgument;
import org.mule.metadata.api.model.ObjectType;

import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * A model which describes that an extension is importing an {@link #getImportedType() imported type}.
 *
 * @since 1.0
 */
public class ImportedTypeModel {

  private ObjectType importedType;

  // Just needed in order to serialize this object
  private ImportedTypeModel() {}

  /**
   * Creates a new instance
   *
   * @param importedType the type to be imported
   * @throws IllegalArgumentException if {@code originExtensionName} is blank or {@code importedType} is {@code null}
   */
  public ImportedTypeModel(ObjectType importedType) {
    checkArgument(importedType != null, "importedType cannot be null");
    this.importedType = importedType;
  }

  public ObjectType getImportedType() {
    return importedType;
  }

  public int hashCode() {
    return reflectionHashCode(this);
  }

  public boolean equals(Object obj) {
    return reflectionEquals(this, obj);
  }

  public String toString() {
    return ToStringBuilder.reflectionToString(this);
  }

}
