/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.extension.model.parameter;

import static org.mule.tooling.client.api.feature.Feature.disabled;
import static org.mule.tooling.client.api.feature.Feature.enabled;
import org.mule.tooling.client.api.extension.model.data.sample.SampleDataProviderModel;
import org.mule.tooling.client.api.extension.model.value.ValueProviderModel;
import org.mule.tooling.client.api.feature.Feature;

import java.util.Objects;

/**
 * An acting parameter of a {@link ValueProviderModel} or {@link SampleDataProviderModel}
 * <p>
 * An acting parameter provides a name, a default value and indicates if it is required
 * </p>
 *
 * @since 1.4
 */
public final class ActingParameterModel {

  private String name;
  private boolean required;
  private Feature<String> extractionExpression;

  // Just needed in order to serialize this object
  private ActingParameterModel() {}

  public ActingParameterModel(String name,
                              boolean required) {
    this(name, required, name);
  }

  public ActingParameterModel(String name,
                              boolean required,
                              String extractionExpression) {
    this.name = name;
    this.required = required;
    this.extractionExpression = enabled(extractionExpression);
  }

  public String getName() {
    return name;
  }

  public boolean isRequired() {
    return required;
  }

  public Feature<String> getExtractionExpression() {
    if (extractionExpression == null) {
      return disabled();
    }
    return extractionExpression;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ActingParameterModel)) {
      return false;
    }
    ActingParameterModel that = (ActingParameterModel) o;
    return Objects.equals(name, that.name) &&
        Objects.equals(required, that.required) &&
        Objects.equals(extractionExpression, that.extractionExpression);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, required, extractionExpression);
  }

  @Override
  public String toString() {
    return "ActingParameterModel{" +
        "name='" + name + '\'' +
        ", required=" + required +
        ", extractionExpression=" +
        (extractionExpression.isEnabled() ? extractionExpression.get() : "DISABLED") +
        '}';
  }
}
