/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.extension.model.property;

/**
 * A model meant to be applied on {@link org.mule.tooling.client.api.extension.model.parameter.ParameterModel} instances which
 * represent an infrastructure parameter.
 *
 * @since 1.0
 */
public class InfrastructureParameterModel {

  private int sequence;

  // Just needed in order to serialize this object
  private InfrastructureParameterModel() {}

  public InfrastructureParameterModel(int sequence) {
    this.sequence = sequence;
  }

  /**
   * @return a sequence indicating the parameters order
   */
  public int getSequence() {
    return sequence;
  }

}
