/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.configuration.ssl;

import static java.lang.String.format;
import static java.util.Objects.requireNonNull;
import static org.apache.commons.lang3.ClassUtils.getShortClassName;
import org.mule.tooling.client.api.configuration.ssl.KeyStoreConfig;
import org.mule.tooling.client.api.configuration.ssl.SslConfiguration;
import org.mule.tooling.client.api.configuration.ssl.TrustStoreConfig;

/**
 * Immutable implementation of {@link SslConfiguration}.
 *
 * @since 1.0
 */
public class ImmutableSslConfiguration implements SslConfiguration {

  private final KeyStoreConfig keyStoreConfig;
  private final TrustStoreConfig trustStoreConfig;

  /**
   * Creates an instance of this configuration.
   *
   * @param keyStoreConfig   a {@link KeyStoreConfig}.
   * @param trustStoreConfig a {@link TrustStoreConfig}.
   */
  public ImmutableSslConfiguration(KeyStoreConfig keyStoreConfig, TrustStoreConfig trustStoreConfig) {
    requireNonNull(keyStoreConfig, "keyStoreConfig cannot be null");
    requireNonNull(trustStoreConfig, "trustStoreConfig cannot be null");

    this.keyStoreConfig = keyStoreConfig;
    this.trustStoreConfig = trustStoreConfig;
  }

  @Override
  public KeyStoreConfig getKeyStoreConfig() {
    return keyStoreConfig;
  }

  @Override
  public TrustStoreConfig getTrustStoreConfig() {
    return trustStoreConfig;
  }

  @Override
  public String toString() {
    return format("%s{keyStoreConfig=%s, trustStoreConfig=%s}", getShortClassName(this.getClass()), keyStoreConfig,
                  trustStoreConfig);
  }

}
