/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.configuration.ssl;

import java.util.Objects;
import org.mule.tooling.client.api.configuration.ssl.KeyStoreConfig;
import org.mule.tooling.client.api.configuration.ssl.TrustStoreConfig;
import org.mule.tooling.client.internal.configuration.ssl.ImmutableSslConfiguration;

public interface SslConfiguration {
    public KeyStoreConfig getKeyStoreConfig();

    public TrustStoreConfig getTrustStoreConfig();

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private KeyStoreConfig keyStoreConfig;
        private TrustStoreConfig trustStoreConfig;

        public Builder withKeyStoreConfig(KeyStoreConfig keyStoreConfig) {
            Objects.requireNonNull(keyStoreConfig, "keyStoreConfig cannot be null");
            this.keyStoreConfig = keyStoreConfig;
            return this;
        }

        public Builder withTrustStoreConfig(TrustStoreConfig trustStoreConfig) {
            Objects.requireNonNull(trustStoreConfig, "trustStoreConfig cannot be null");
            this.trustStoreConfig = trustStoreConfig;
            return this;
        }

        public SslConfiguration build() {
            return new ImmutableSslConfiguration(this.keyStoreConfig, this.trustStoreConfig);
        }
    }
}

