/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.message.history;

import java.util.Map;
import org.mule.tooling.client.api.message.history.Message;
import org.mule.tooling.client.api.message.history.Notification;
import org.mule.tooling.client.api.message.history.NotificationAction;
import org.mule.tooling.client.api.message.history.TypedValue;

public class ImmutableNotification
implements Notification {
    private String application;
    private long timestamp;
    private NotificationAction action;
    private String component;
    private Message message;
    private String componentPath;
    private String correlationId;
    private Map<String, TypedValue> variables;

    private ImmutableNotification() {
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String getApplication() {
        return this.application;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public NotificationAction getAction() {
        return this.action;
    }

    @Override
    public String getComponent() {
        return this.component;
    }

    @Override
    public Message getMessage() {
        return this.message;
    }

    @Override
    public String getComponentPath() {
        return this.componentPath;
    }

    @Override
    public String getCorrelationId() {
        return this.correlationId;
    }

    @Override
    public Map<String, TypedValue> getVariables() {
        return this.variables;
    }

    public static class Builder {
        private ImmutableNotification immutableNotification = new ImmutableNotification();

        private Builder() {
        }

        public Builder applicationName(String application) {
            this.immutableNotification.application = application;
            return this;
        }

        public Builder timestamp(long timestamp) {
            this.immutableNotification.timestamp = timestamp;
            return this;
        }

        public Builder action(NotificationAction action) {
            this.immutableNotification.action = action;
            return this;
        }

        public Builder component(String component) {
            this.immutableNotification.component = component;
            return this;
        }

        public Builder message(Message message) {
            this.immutableNotification.message = message;
            return this;
        }

        public Builder componentPath(String componentPath) {
            this.immutableNotification.componentPath = componentPath;
            return this;
        }

        public Builder correlationId(String correlationId) {
            this.immutableNotification.correlationId = correlationId;
            return this;
        }

        public Builder variables(Map<String, TypedValue> variables) {
            this.immutableNotification.variables = variables;
            return this;
        }

        public ImmutableNotification build() {
            return this.immutableNotification;
        }
    }
}

