/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.extension.model.parameter;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.api.extension.model.DisplayModel;
import org.mule.tooling.client.api.extension.model.ExpressionSupport;
import org.mule.tooling.client.api.extension.model.LayoutModel;
import org.mule.tooling.client.api.extension.model.ParameterDslConfiguration;
import org.mule.tooling.client.api.extension.model.StereotypeModel;
import org.mule.tooling.client.api.extension.model.deprecated.DeprecationModel;
import org.mule.tooling.client.api.extension.model.metadata.MetadataKeyPartModel;
import org.mule.tooling.client.api.extension.model.parameter.ParameterRole;
import org.mule.tooling.client.api.extension.model.property.DefaultImplementingTypeModel;
import org.mule.tooling.client.api.extension.model.property.InfrastructureParameterModel;
import org.mule.tooling.client.api.extension.model.property.NoWrapperModel;
import org.mule.tooling.client.api.extension.model.property.QNameModel;
import org.mule.tooling.client.api.extension.model.semantic.HasSemanticTerms;
import org.mule.tooling.client.api.extension.model.value.FieldValueProviderModel;
import org.mule.tooling.client.api.extension.model.value.FieldValuesResolverModel;
import org.mule.tooling.client.api.extension.model.value.ValueProviderModel;
import org.mule.tooling.client.api.extension.model.value.ValuesResolverModel;
import org.mule.tooling.client.api.feature.Feature;

public final class ParameterModel
implements HasSemanticTerms {
    private String name;
    private String description;
    private DisplayModel displayModel;
    private MetadataType type;
    private boolean hasDynamicType;
    private boolean required;
    private boolean isConfigOverride;
    private ExpressionSupport expressionSupport;
    private Object defaultValue;
    private ParameterRole role;
    private ParameterDslConfiguration dslConfiguration;
    private LayoutModel layoutModel;
    private ValueProviderModel valueProviderModel;
    private List<StereotypeModel> allowedStereotypes;
    private Feature<DeprecationModel> deprecationModel;
    private Feature<Boolean> isComponentId;
    private Feature<ValuesResolverModel> valuesResolverModel;
    private List<FieldValueProviderModel> fieldValueProviderModels;
    private List<FieldValuesResolverModel> fieldValuesResolverModels;
    private MetadataKeyPartModel metadataKeyPartModel;
    private QNameModel qNameModel;
    private InfrastructureParameterModel infrastructureParameterModel;
    private DefaultImplementingTypeModel defaultImplementingTypeModel;
    private NoWrapperModel noWrapperModel;
    private Set<String> semanticTerms;

    private ParameterModel() {
    }

    @Deprecated
    public ParameterModel(String name, String description, DisplayModel displayModel, MetadataType type, boolean hasDynamicType, boolean required, boolean isConfigOverride, boolean isComponentId, ExpressionSupport expressionSupport, Object defaultValue, ParameterRole role, ParameterDslConfiguration dslConfiguration, LayoutModel layoutModel, MetadataKeyPartModel metadataKeyPartModel, QNameModel qNameModel, InfrastructureParameterModel infrastructureParameterModel, DefaultImplementingTypeModel defaultImplementingTypeModel, NoWrapperModel noWrapperModel, ValueProviderModel valueProviderModel, List<StereotypeModel> allowedStereotypes, DeprecationModel deprecationModel, ValuesResolverModel valuesResolverModel) {
        this(name, description, displayModel, type, hasDynamicType, required, isConfigOverride, isComponentId, expressionSupport, defaultValue, role, dslConfiguration, layoutModel, metadataKeyPartModel, qNameModel, infrastructureParameterModel, defaultImplementingTypeModel, noWrapperModel, valueProviderModel, allowedStereotypes, deprecationModel, valuesResolverModel, null, null);
    }

    public ParameterModel(String name, String description, DisplayModel displayModel, MetadataType type, boolean hasDynamicType, boolean required, boolean isConfigOverride, boolean isComponentId, ExpressionSupport expressionSupport, Object defaultValue, ParameterRole role, ParameterDslConfiguration dslConfiguration, LayoutModel layoutModel, MetadataKeyPartModel metadataKeyPartModel, QNameModel qNameModel, InfrastructureParameterModel infrastructureParameterModel, DefaultImplementingTypeModel defaultImplementingTypeModel, NoWrapperModel noWrapperModel, ValueProviderModel valueProviderModel, List<StereotypeModel> allowedStereotypes, DeprecationModel deprecationModel, ValuesResolverModel valuesResolverModel, List<FieldValueProviderModel> fieldValueProviderModels, List<FieldValuesResolverModel> fieldValuesResolverModels) {
        this(name, description, displayModel, type, hasDynamicType, required, isConfigOverride, isComponentId, expressionSupport, defaultValue, role, dslConfiguration, layoutModel, metadataKeyPartModel, qNameModel, infrastructureParameterModel, defaultImplementingTypeModel, noWrapperModel, valueProviderModel, allowedStereotypes, deprecationModel, valuesResolverModel, fieldValueProviderModels, fieldValuesResolverModels, Collections.emptySet());
    }

    public ParameterModel(String name, String description, DisplayModel displayModel, MetadataType type, boolean hasDynamicType, boolean required, boolean isConfigOverride, boolean isComponentId, ExpressionSupport expressionSupport, Object defaultValue, ParameterRole role, ParameterDslConfiguration dslConfiguration, LayoutModel layoutModel, MetadataKeyPartModel metadataKeyPartModel, QNameModel qNameModel, InfrastructureParameterModel infrastructureParameterModel, DefaultImplementingTypeModel defaultImplementingTypeModel, NoWrapperModel noWrapperModel, ValueProviderModel valueProviderModel, List<StereotypeModel> allowedStereotypes, DeprecationModel deprecationModel, ValuesResolverModel valuesResolverModel, List<FieldValueProviderModel> fieldValueProviderModels, List<FieldValuesResolverModel> fieldValuesResolverModels, Set<String> semanticTerms) {
        this.name = name;
        this.description = description;
        this.displayModel = displayModel;
        this.type = type;
        this.hasDynamicType = hasDynamicType;
        this.required = required;
        this.isConfigOverride = isConfigOverride;
        this.isComponentId = Feature.enabled(isComponentId);
        this.expressionSupport = expressionSupport;
        this.defaultValue = defaultValue;
        this.role = role;
        this.dslConfiguration = dslConfiguration;
        this.layoutModel = layoutModel;
        this.metadataKeyPartModel = metadataKeyPartModel;
        this.qNameModel = qNameModel;
        this.infrastructureParameterModel = infrastructureParameterModel;
        this.defaultImplementingTypeModel = defaultImplementingTypeModel;
        this.noWrapperModel = noWrapperModel;
        this.valueProviderModel = valueProviderModel;
        this.allowedStereotypes = allowedStereotypes;
        this.deprecationModel = Feature.enabled(deprecationModel);
        this.valuesResolverModel = Feature.enabled(valuesResolverModel);
        this.fieldValueProviderModels = fieldValueProviderModels == null ? Collections.emptyList() : fieldValueProviderModels;
        this.fieldValuesResolverModels = fieldValuesResolverModels == null ? Collections.emptyList() : fieldValuesResolverModels;
        this.semanticTerms = new HashSet<String>(semanticTerms);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Optional<DisplayModel> getDisplayModel() {
        return Optional.ofNullable(this.displayModel);
    }

    public MetadataType getType() {
        return this.type;
    }

    public boolean hasDynamicType() {
        return this.hasDynamicType;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isOverrideFromConfig() {
        return this.isConfigOverride;
    }

    public ExpressionSupport getExpressionSupport() {
        return this.expressionSupport;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public ParameterDslConfiguration getDslConfiguration() {
        return this.dslConfiguration;
    }

    public ParameterRole getRole() {
        return this.role;
    }

    public Optional<LayoutModel> getLayoutModel() {
        return Optional.ofNullable(this.layoutModel);
    }

    public Optional<MetadataKeyPartModel> getMetadataKeyPartModel() {
        return Optional.ofNullable(this.metadataKeyPartModel);
    }

    public Optional<QNameModel> getQNameModel() {
        return Optional.ofNullable(this.qNameModel);
    }

    public Optional<InfrastructureParameterModel> getInfrastructureParameterModel() {
        return Optional.ofNullable(this.infrastructureParameterModel);
    }

    public Optional<DefaultImplementingTypeModel> getDefaultImplementingTypeModel() {
        return Optional.ofNullable(this.defaultImplementingTypeModel);
    }

    public Optional<NoWrapperModel> getNoWrapperModel() {
        return Optional.ofNullable(this.noWrapperModel);
    }

    public Optional<ValueProviderModel> getValueProviderModel() {
        return Optional.ofNullable(this.valueProviderModel);
    }

    public List<StereotypeModel> getAllowedStereotypes() {
        return this.allowedStereotypes;
    }

    public Feature<Boolean> isComponentId() {
        if (this.isComponentId == null) {
            this.isComponentId = Feature.disabled();
        }
        return this.isComponentId;
    }

    public Feature<DeprecationModel> getDeprecationModel() {
        if (this.deprecationModel == null) {
            this.deprecationModel = Feature.disabled();
        }
        return this.deprecationModel;
    }

    public Feature<ValuesResolverModel> getValuesResolverModel() {
        if (this.valuesResolverModel == null) {
            this.valuesResolverModel = Feature.disabled();
        }
        return this.valuesResolverModel;
    }

    public List<FieldValueProviderModel> getFieldValueProviderModels() {
        if (this.fieldValueProviderModels == null) {
            this.fieldValueProviderModels = Collections.emptyList();
        }
        return this.fieldValueProviderModels;
    }

    public List<FieldValuesResolverModel> getFieldValuesResolverModels() {
        if (this.fieldValuesResolverModels == null) {
            this.fieldValuesResolverModels = Collections.emptyList();
        }
        return this.fieldValuesResolverModels;
    }

    @Override
    public Set<String> getSemanticTerms() {
        if (this.semanticTerms == null) {
            this.semanticTerms = Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.semanticTerms);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        return this.getClass().isInstance(obj) && this.name.equals(((ParameterModel)obj).getName());
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

