/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.icons;

import java.util.Map;
import java.util.Optional;

/**
 * Describes the result of retrieving icons from an extension
 *
 * @since 1.1.0
 */
public interface IconsResult {

  /**
   * @return The default and main icon from an extension.
   */
  Optional<byte[]> getExtensionIcon();

  /**
   * @return A map of additional icons.
   */
  Map<String, byte[]> getAdditionalIcons();
}
