/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.declaration.type.annotation;

import static org.mule.tooling.client.internal.util.Preconditions.checkState;

import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.tooling.client.api.extension.model.StereotypeModel;

import java.util.List;

/**
 * A public {@link TypeAnnotation} intended to be used on {@link ObjectFieldType} types in order to communicate an associated
 * {@link StereotypeModel}
 *
 * @since 1.0
 */
public class StereotypeTypeAnnotation implements TypeAnnotation {

  public static final String NAME = "stereotype";
  private List<StereotypeModel> allowedStereotypes;

  /**
   * Creates a new instance
   *
   * @param allowedStereotypes the reference to be communicated
   */
  public StereotypeTypeAnnotation(List<StereotypeModel> allowedStereotypes) {
    this.allowedStereotypes = allowedStereotypes;
  }

  /**
   * @return The allowed {@link StereotypeModel stereotypes}
   */
  public List<StereotypeModel> getStereotypeModel() {
    checkState(allowedStereotypes != null, "The stereotypeModel has not yet been resolved");
    return allowedStereotypes;
  }

  /**
   * {@inheritDoc}
   *
   * @return {@link #NAME}
   */
  @Override
  public String getName() {
    return NAME;
  }

  @Override
  public int hashCode() {
    return allowedStereotypes.hashCode();
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj) {
      return true;
    }
    if (obj == null) {
      return false;
    }
    if (getClass() != obj.getClass()) {
      return false;
    }
    StereotypeTypeAnnotation other = (StereotypeTypeAnnotation) obj;
    if (allowedStereotypes == null) {
      if (other.allowedStereotypes != null) {
        return false;
      }
    } else if (!allowedStereotypes.equals(other.allowedStereotypes)) {
      return false;
    }
    return true;
  }

}
