/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.extension.model.connection;

import org.mule.tooling.client.api.types.UnknownType;

/**
 * Defines he different strategies that the runtime supports for managing connections.
 * <p>
 * Only one value should be enabled at one time.
 *
 * @since 1.0
 */
public class ConnectionManagementType extends UnknownType {

  private boolean pooling = false;
  private boolean cached = false;
  private boolean none = false;

  // Just needed in order to serialize this object
  private ConnectionManagementType() {}

  public ConnectionManagementType(String value) {
    super(value);
  }

  public static ConnectionManagementType poolingConnectionManagementType(String value) {
    ConnectionManagementType type = new ConnectionManagementType(value);
    type.pooling = true;
    return type;
  }

  public static ConnectionManagementType cachedConnectionManagementType(String value) {
    ConnectionManagementType type = new ConnectionManagementType(value);
    type.cached = true;
    return type;
  }

  public static ConnectionManagementType noneConnectionManagementType(String value) {
    ConnectionManagementType type = new ConnectionManagementType(value);
    type.none = true;
    return type;
  }

  /**
   * @return {@code true} if connections are pooled
   */
  public boolean isPooling() {
    return pooling;
  }

  /**
   * @return {@code true} if connections are cached
   */
  public boolean isCached() {
    return cached;
  }

  /**
   * @return {@code true} if connections are created upon operation execution and destroyed when operation finished
   */
  public boolean isNone() {
    return none;
  }

}
