/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.declaration.type.annotation;

import org.mule.metadata.api.annotation.MarkerAnnotation;

/**
 * A TypeAnnotation used as a marker for ObjectType instances, signaling that such type is an Infrastructure Type.
 *
 * @since 1.4.0
 */
public class InfrastructureTypeAnnotation extends MarkerAnnotation {

  public static final String NAME = "infrastructureType";

  @Override
  public String getName() {
    return NAME;
  }

}
