/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.extension.model.nested;


import static java.util.Collections.emptySet;

import org.mule.tooling.client.api.extension.model.DisplayModel;
import org.mule.tooling.client.api.extension.model.ErrorModel;
import org.mule.tooling.client.api.extension.model.StereotypeModel;
import org.mule.tooling.client.api.extension.model.deprecated.DeprecationModel;
import org.mule.tooling.client.api.extension.model.parameter.ParameterGroupModel;

import java.util.List;
import java.util.Optional;
import java.util.Set;

/**
 * Represents a {@link NestableElementModel} that makes reference to a chain of ComponentModels. This chain can have any number of
 * components of the allowed stereotypes.
 *
 * @since 1.0
 */
public class NestedChainModel extends NestedComponentModel {

  public NestedChainModel() {}

  /**
   * Creates a new instance
   *
   * @param name               the model's name
   * @param description        the model's description
   * @param displayModel       a model containing directives about how this component is to be displayed in the UI
   * @param isRequired         whether or not this component is required
   * @param allowedStereotypes A {@link Set} of custom properties which extend this model
   * @throws IllegalArgumentException if {@code name} is blank
   * @deprecated use
   *             {@link NestedChainModel#NestedChainModel(String, String, DisplayModel, boolean, Set, List, DeprecationModel, Set, Integer, Optional, List, StereotypeModel)}
   */
  @Deprecated
  public NestedChainModel(String name, String description, DisplayModel displayModel,
                          boolean isRequired, Set<StereotypeModel> allowedStereotypes) {
    this(name, description, displayModel, isRequired, allowedStereotypes, null, null, null, null, null, null, null, emptySet());
  }

  /**
   * Creates a new instance
   *
   * @param name                 the model's name
   * @param description          the model's description
   * @param displayModel         a model containing directives about how this component is to be displayed in the UI
   * @param isRequired           whether or not this component is required
   * @param allowedStereotypes   A {@link Set} of custom properties which extend this model
   * @param parameterGroupModels The list of {@link ParameterGroupModel}s this component contains
   * @param deprecationModel     a {@link DeprecationModel} describing if the component is deprecated. A null value means it is
   *                             not deprecated.
   * @param errorModels          a {@link Set<ErrorModel>} of errors this component could throw
   * @param minOccurs            The min number of occurences for this component
   * @param maxOccurs            The max number of occurences for this component
   * @param nestedComponents     a {@link List} with the components contained by this model
   * @param stereotypeModel      the {@link StereotypeModel stereotype} of this component
   * @throws IllegalArgumentException if {@code name} is blank
   * @since 1.4.0
   */
  public NestedChainModel(String name, String description, DisplayModel displayModel, boolean isRequired,
                          Set<StereotypeModel> allowedStereotypes, List<ParameterGroupModel> parameterGroupModels,
                          DeprecationModel deprecationModel, Set<ErrorModel> errorModels, Integer minOccurs,
                          Integer maxOccurs, List<? extends NestableElementModel> nestedComponents,
                          StereotypeModel stereotypeModel, Set<String> semanticTerms) {
    super(name, description, displayModel, isRequired, allowedStereotypes, parameterGroupModels, deprecationModel, errorModels,
          minOccurs, maxOccurs, nestedComponents, stereotypeModel, semanticTerms);
  }

  @Override
  public void accept(NestableElementModelVisitor visitor) {
    visitor.visit(this);
  }

}
