/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public class InputStreamKryoSerializer
extends Serializer<InputStream> {
    public void write(Kryo kryo, Output output, InputStream in) {
        this.writeStream(output, in);
    }

    public InputStream read(Kryo kryo, Input input, Class<InputStream> type) {
        return new ByteArrayInputStream(this.readBytes(input));
    }

    private void writeStream(Output output, InputStream in) {
        byte[] content;
        try {
            content = IOUtils.toByteArray((InputStream)in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        output.writeVarInt(content.length, true);
        output.write(content);
    }

    private byte[] readBytes(Input input) {
        int length = input.readInt(true);
        byte[] content = new byte[length];
        input.read(content, 0, length);
        return content;
    }
}

