/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.icons;

import static java.util.Optional.ofNullable;

import java.util.Map;
import java.util.Optional;

/**
 * {@link IconsResult} default implementation
 *
 * @since 1.1
 */
public class DefaultIconsResult implements IconsResult {

  private byte[] defaultIcon;
  private Map<String, byte[]> additionalIcons;

  public DefaultIconsResult(byte[] defaultIcon, Map<String, byte[]> additionalIcons) {
    this.defaultIcon = defaultIcon;
    this.additionalIcons = additionalIcons;
  }

  @Override
  public Optional<byte[]> getExtensionIcon() {
    return ofNullable(defaultIcon);
  }

  @Override
  public Map<String, byte[]> getAdditionalIcons() {
    return additionalIcons;
  }
}
