/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.extension.model.nested;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.mule.tooling.client.api.extension.model.DisplayModel;
import org.mule.tooling.client.api.extension.model.ErrorModel;
import org.mule.tooling.client.api.extension.model.StereotypeModel;
import org.mule.tooling.client.api.extension.model.deprecated.DeprecationModel;
import org.mule.tooling.client.api.extension.model.nested.NestableElementModel;
import org.mule.tooling.client.api.extension.model.nested.NestableElementModelVisitor;
import org.mule.tooling.client.api.extension.model.parameter.ParameterGroupModel;
import org.mule.tooling.client.api.feature.Feature;

public class NestedRouteModel
implements NestableElementModel {
    private String name;
    private int minOccurs;
    private Integer maxOccurs;
    private String description;
    private DisplayModel displayModel;
    private List<ParameterGroupModel> parameterGroupModels;
    private List<? extends NestableElementModel> childComponents;
    private Feature<DeprecationModel> deprecationModel;
    private Feature<Set<ErrorModel>> errorModels;
    private Feature<StereotypeModel> stereotypeModel;
    private Set<String> semanticTerms;

    public NestedRouteModel() {
    }

    @Deprecated
    public NestedRouteModel(String name, String description, DisplayModel displayModel, int minOccurs, Integer maxOccurs, List<ParameterGroupModel> parameterGroupModels, List<? extends NestableElementModel> childComponents) {
        this(name, description, displayModel, minOccurs, maxOccurs, parameterGroupModels, childComponents, null, null, null, Collections.emptySet());
    }

    public NestedRouteModel(String name, String description, DisplayModel displayModel, int minOccurs, Integer maxOccurs, List<ParameterGroupModel> parameterGroupModels, List<? extends NestableElementModel> childComponents, DeprecationModel deprecationModel, Set<ErrorModel> errorModels, StereotypeModel stereotypeModel, Set<String> semanticTerms) {
        this.name = name;
        this.description = description;
        this.parameterGroupModels = parameterGroupModels;
        this.displayModel = displayModel;
        this.minOccurs = minOccurs;
        this.maxOccurs = maxOccurs;
        this.childComponents = childComponents == null ? ImmutableList.of() : ImmutableList.copyOf(childComponents);
        this.deprecationModel = Feature.enabled(deprecationModel);
        this.errorModels = Feature.enabled(errorModels);
        this.stereotypeModel = Feature.enabled(stereotypeModel);
        this.semanticTerms = new HashSet<String>(semanticTerms);
    }

    public boolean isRequired() {
        return this.minOccurs > 0;
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public Optional<Integer> getMaxOccurs() {
        return Optional.ofNullable(this.maxOccurs);
    }

    public List<? extends NestableElementModel> getNestedComponents() {
        return this.childComponents;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public DisplayModel getDisplayModel() {
        return this.displayModel;
    }

    public List<ParameterGroupModel> getParameterGroupModels() {
        return this.parameterGroupModels;
    }

    public List<? extends NestableElementModel> getChildComponents() {
        return this.childComponents;
    }

    public Feature<DeprecationModel> getDeprecationModel() {
        if (this.deprecationModel == null) {
            return Feature.disabled();
        }
        return this.deprecationModel;
    }

    public Feature<Set<ErrorModel>> getErrorModels() {
        if (this.errorModels == null) {
            return Feature.disabled();
        }
        return this.errorModels;
    }

    public Feature<StereotypeModel> getStereotype() {
        if (this.stereotypeModel == null) {
            return Feature.disabled();
        }
        return this.stereotypeModel;
    }

    @Override
    public Set<String> getSemanticTerms() {
        if (this.semanticTerms == null) {
            this.semanticTerms = Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.semanticTerms);
    }

    @Override
    public void accept(NestableElementModelVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object obj) {
        return this.getClass().isInstance(obj) && this.name.equals(((NestedRouteModel)obj).getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

