/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.extension.model.source;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.mule.tooling.client.api.extension.model.ComponentModel;
import org.mule.tooling.client.api.extension.model.DisplayModel;
import org.mule.tooling.client.api.extension.model.ErrorModel;
import org.mule.tooling.client.api.extension.model.OutputModel;
import org.mule.tooling.client.api.extension.model.StereotypeModel;
import org.mule.tooling.client.api.extension.model.data.sample.SampleDataProviderModel;
import org.mule.tooling.client.api.extension.model.deprecated.DeprecationModel;
import org.mule.tooling.client.api.extension.model.metadata.MetadataKeyIdModel;
import org.mule.tooling.client.api.extension.model.metadata.TypeResolversInformationModel;
import org.mule.tooling.client.api.extension.model.nested.NestableElementModel;
import org.mule.tooling.client.api.extension.model.parameter.ParameterGroupModel;
import org.mule.tooling.client.api.extension.model.source.SourceCallbackModel;
import org.mule.tooling.client.api.feature.Feature;

public class SourceModel
implements ComponentModel {
    private String name;
    private String description;
    private List<ParameterGroupModel> parameterGroupModels;
    private DisplayModel displayModel;
    private OutputModel output;
    private OutputModel outputAttributes;
    private boolean transactional;
    private boolean requiresConnection;
    private boolean supportsStreaming;
    private StereotypeModel stereotype;
    private boolean hasResponse;
    private SourceCallbackModel successCallback;
    private SourceCallbackModel errorCallback;
    private SourceCallbackModel terminateCallbackModel;
    private Set<ErrorModel> errors;
    private List<? extends NestableElementModel> nestedComponents;
    private Feature<Boolean> runsOnPrimaryNodeOnly;
    private Feature<DeprecationModel> deprecationModel;
    private Feature<SampleDataProviderModel> sampleDataProviderModel;
    private Set<String> semanticTerms;
    private MetadataKeyIdModel metadataKeyIdModel;
    private Feature<TypeResolversInformationModel> typeResolversInformationModel;

    private SourceModel() {
    }

    @Deprecated
    public SourceModel(String name, String description, List<ParameterGroupModel> parameterGroupModels, DisplayModel displayModel, OutputModel output, OutputModel outputAttributes, boolean transactional, boolean requiresConnection, boolean supportsStreaming, StereotypeModel stereotype, boolean hasResponse, boolean runsOnPrimaryNodeOnly, SourceCallbackModel successCallback, SourceCallbackModel errorCallback, SourceCallbackModel terminateCallbackModel, Set<ErrorModel> errors, List<? extends NestableElementModel> nestedComponents, MetadataKeyIdModel metadataKeyIdModel, DeprecationModel deprecationModel) {
        this(name, description, parameterGroupModels, displayModel, output, outputAttributes, transactional, requiresConnection, supportsStreaming, stereotype, hasResponse, runsOnPrimaryNodeOnly, successCallback, errorCallback, terminateCallbackModel, errors, nestedComponents, metadataKeyIdModel, deprecationModel, null, null);
    }

    public SourceModel(String name, String description, List<ParameterGroupModel> parameterGroupModels, DisplayModel displayModel, OutputModel output, OutputModel outputAttributes, boolean transactional, boolean requiresConnection, boolean supportsStreaming, StereotypeModel stereotype, boolean hasResponse, boolean runsOnPrimaryNodeOnly, SourceCallbackModel successCallback, SourceCallbackModel errorCallback, SourceCallbackModel terminateCallbackModel, Set<ErrorModel> errors, List<? extends NestableElementModel> nestedComponents, MetadataKeyIdModel metadataKeyIdModel, DeprecationModel deprecationModel, TypeResolversInformationModel typeResolversInformationModel, SampleDataProviderModel sampleDataProviderModel) {
        this(name, description, parameterGroupModels, displayModel, output, outputAttributes, transactional, requiresConnection, supportsStreaming, stereotype, hasResponse, runsOnPrimaryNodeOnly, successCallback, errorCallback, terminateCallbackModel, errors, nestedComponents, metadataKeyIdModel, deprecationModel, typeResolversInformationModel, sampleDataProviderModel, Collections.emptySet());
    }

    public SourceModel(String name, String description, List<ParameterGroupModel> parameterGroupModels, DisplayModel displayModel, OutputModel output, OutputModel outputAttributes, boolean transactional, boolean requiresConnection, boolean supportsStreaming, StereotypeModel stereotype, boolean hasResponse, boolean runsOnPrimaryNodeOnly, SourceCallbackModel successCallback, SourceCallbackModel errorCallback, SourceCallbackModel terminateCallbackModel, Set<ErrorModel> errors, List<? extends NestableElementModel> nestedComponents, MetadataKeyIdModel metadataKeyIdModel, DeprecationModel deprecationModel, TypeResolversInformationModel typeResolversInformationModel, SampleDataProviderModel sampleDataProviderModel, Set<String> semanticTerms) {
        this.name = name;
        this.description = description;
        this.parameterGroupModels = parameterGroupModels;
        this.displayModel = displayModel;
        this.output = output;
        this.outputAttributes = outputAttributes;
        this.transactional = transactional;
        this.requiresConnection = requiresConnection;
        this.supportsStreaming = supportsStreaming;
        this.stereotype = stereotype;
        this.hasResponse = hasResponse;
        this.successCallback = successCallback;
        this.errorCallback = errorCallback;
        this.terminateCallbackModel = terminateCallbackModel;
        this.errors = errors;
        this.nestedComponents = nestedComponents;
        this.metadataKeyIdModel = metadataKeyIdModel;
        this.runsOnPrimaryNodeOnly = Feature.enabled(runsOnPrimaryNodeOnly);
        this.deprecationModel = Feature.enabled(deprecationModel);
        this.typeResolversInformationModel = Feature.enabled(typeResolversInformationModel);
        this.sampleDataProviderModel = Feature.enabled(sampleDataProviderModel);
        this.semanticTerms = new HashSet<String>(semanticTerms);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<ParameterGroupModel> getParameterGroupModels() {
        return this.parameterGroupModels;
    }

    @Override
    public Optional<DisplayModel> getDisplayModel() {
        return Optional.ofNullable(this.displayModel);
    }

    public OutputModel getOutput() {
        return this.output;
    }

    public OutputModel getOutputAttributes() {
        return this.outputAttributes;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public boolean requiresConnection() {
        return this.requiresConnection;
    }

    public boolean supportsStreaming() {
        return this.supportsStreaming;
    }

    @Override
    public StereotypeModel getStereotype() {
        return this.stereotype;
    }

    public boolean hasResponse() {
        return this.hasResponse;
    }

    public Optional<SourceCallbackModel> getSuccessCallback() {
        return Optional.ofNullable(this.successCallback);
    }

    public Optional<SourceCallbackModel> getErrorCallback() {
        return Optional.ofNullable(this.errorCallback);
    }

    public Optional<SourceCallbackModel> getTerminateCallback() {
        return Optional.ofNullable(this.terminateCallbackModel);
    }

    @Override
    public Set<ErrorModel> getErrorModels() {
        return this.errors;
    }

    @Override
    public List<? extends NestableElementModel> getNestedComponents() {
        return this.nestedComponents;
    }

    public Optional<MetadataKeyIdModel> getMetadataKeyIdModel() {
        return Optional.ofNullable(this.metadataKeyIdModel);
    }

    public Feature<Boolean> getRunsOnPrimaryNodeOnly() {
        if (this.runsOnPrimaryNodeOnly == null) {
            this.runsOnPrimaryNodeOnly = Feature.disabled();
        }
        return this.runsOnPrimaryNodeOnly;
    }

    public Feature<DeprecationModel> getDeprecationModel() {
        if (this.deprecationModel == null) {
            this.deprecationModel = Feature.disabled();
        }
        return this.deprecationModel;
    }

    @Override
    public Feature<TypeResolversInformationModel> getTypeResolversInformationModel() {
        if (this.typeResolversInformationModel == null) {
            this.typeResolversInformationModel = Feature.disabled();
        }
        return this.typeResolversInformationModel;
    }

    public Feature<SampleDataProviderModel> getSampleDataProviderModel() {
        if (this.sampleDataProviderModel == null) {
            this.sampleDataProviderModel = Feature.disabled();
        }
        return this.sampleDataProviderModel;
    }

    @Override
    public Set<String> getSemanticTerms() {
        if (this.semanticTerms == null) {
            this.semanticTerms = Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.semanticTerms);
    }

    @Override
    public Optional<ParameterGroupModel> getParameterGroupModel(String name) {
        return this.parameterGroupModels.stream().filter(model -> model.getName().equals(name)).findFirst();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        return this.getClass().isInstance(obj) && this.name.equals(((SourceModel)obj).getName());
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

