/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.persistence;

import java.util.Collections;
import java.util.Map;
import org.mule.tooling.client.api.component.ComponentIdentifier;
import org.mule.tooling.client.api.extension.model.ErrorModel;
import org.mule.tooling.client.api.extension.model.ErrorModelBuilder;

public class ErrorModelToIdentifierSerializer {
    public static ErrorModel deserialize(String errorIdentifier, Map<String, ErrorModel> errorModelRepository) {
        boolean exists = errorModelRepository.containsKey(errorIdentifier);
        if (exists) {
            return errorModelRepository.get(errorIdentifier);
        }
        return ErrorModelToIdentifierSerializer.createErrorModel(errorIdentifier);
    }

    public static ErrorModel deserialize(String errorIdentifier) {
        return ErrorModelToIdentifierSerializer.deserialize(errorIdentifier, Collections.emptyMap());
    }

    public static String serialize(ErrorModel errorModel) {
        return errorModel.getNamespace() + ":" + errorModel.getType();
    }

    private static ErrorModel createErrorModel(String errorIdentifier) {
        ComponentIdentifier componentIdentifier = ComponentIdentifier.buildFromStringRepresentation(errorIdentifier);
        return ErrorModelBuilder.newError(componentIdentifier).build();
    }
}

