/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.datasense;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.api.component.location.Location;
import org.mule.tooling.client.api.datasense.DataSenseElementInfo;
import org.mule.tooling.client.api.datasense.DataSenseNotification;
import org.mule.tooling.client.api.extension.model.operation.OperationModel;
import org.mule.tooling.client.api.extension.model.source.SourceModel;

public class DataSenseInfo {
    private MetadataType input;
    private MetadataType output;
    private MetadataType income;
    private MetadataType expected;
    private MetadataType actualInput;
    private MetadataType actualOutput;
    private MetadataType expectedInput;
    private MetadataType expectedOutput;
    private MetadataType result;
    private OperationModel operationModel;
    private SourceModel sourceModel;
    private List<String> messages;
    private Location location;
    private Map<Location, DataSenseElementInfo> componentInfoByComponentPath;
    private List<DataSenseNotification> notifications;
    private Map<String, MetadataType> globalBindings = new HashMap<String, MetadataType>();
    private Map<String, MetadataType> functionBindings = new HashMap<String, MetadataType>();

    public Location getLocation() {
        return this.location;
    }

    public Optional<MetadataType> getInput() {
        return Optional.ofNullable(this.input);
    }

    public Optional<MetadataType> getOutput() {
        return Optional.ofNullable(this.output);
    }

    public Optional<MetadataType> getIncoming() {
        return Optional.ofNullable(this.income);
    }

    public Optional<MetadataType> getExpected() {
        return Optional.ofNullable(this.expected);
    }

    public Optional<MetadataType> getActualInput() {
        return Optional.ofNullable(this.actualInput);
    }

    public Optional<MetadataType> getActualOutput() {
        return Optional.ofNullable(this.actualOutput);
    }

    public Optional<MetadataType> getExpectedInput() {
        return Optional.ofNullable(this.expectedInput);
    }

    public Optional<MetadataType> getExpectedOutput() {
        return Optional.ofNullable(this.expectedOutput);
    }

    public Optional<MetadataType> getResult() {
        return Optional.ofNullable(this.result);
    }

    public Optional<OperationModel> getOperationModel() {
        return Optional.ofNullable(this.operationModel);
    }

    public Optional<SourceModel> getSourceModel() {
        return Optional.ofNullable(this.sourceModel);
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public List<DataSenseNotification> getDataSenseNotifications() {
        return this.notifications;
    }

    public Optional<Map<Location, DataSenseElementInfo>> getComponentInfoByComponentPath() {
        return Optional.ofNullable(this.componentInfoByComponentPath);
    }

    public Map<String, MetadataType> getGlobalBindings() {
        return this.globalBindings;
    }

    public Map<String, MetadataType> getFunctionBindings() {
        return this.functionBindings;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        DataSenseInfo dataSenseInfo = new DataSenseInfo();

        public Builder withLocation(Location location) {
            this.dataSenseInfo.location = location;
            return this;
        }

        public Builder withInput(MetadataType input) {
            this.dataSenseInfo.input = input;
            return this;
        }

        public Builder withOutput(MetadataType output) {
            this.dataSenseInfo.output = output;
            return this;
        }

        public Builder withIncoming(MetadataType income) {
            this.dataSenseInfo.income = income;
            return this;
        }

        public Builder withExpected(MetadataType expected) {
            this.dataSenseInfo.expected = expected;
            return this;
        }

        public Builder withActualInput(MetadataType actualInput) {
            this.dataSenseInfo.actualInput = actualInput;
            return this;
        }

        public Builder withActualOutput(MetadataType actualOutput) {
            this.dataSenseInfo.actualOutput = actualOutput;
            return this;
        }

        public Builder withExpectedInput(MetadataType expectedInput) {
            this.dataSenseInfo.expectedInput = expectedInput;
            return this;
        }

        public Builder withExpectedOutput(MetadataType expectedOutput) {
            this.dataSenseInfo.expectedOutput = expectedOutput;
            return this;
        }

        public Builder withResult(MetadataType result) {
            this.dataSenseInfo.result = result;
            return this;
        }

        public Builder withOperationModel(OperationModel operationModel) {
            this.dataSenseInfo.operationModel = operationModel;
            return this;
        }

        public Builder withSourceModel(SourceModel sourceModel) {
            this.dataSenseInfo.sourceModel = sourceModel;
            return this;
        }

        public Builder withMessages(List<String> messages) {
            this.dataSenseInfo.messages = messages;
            return this;
        }

        public Builder withComponentInfoByComponentPath(Map<Location, DataSenseElementInfo> componentInfoByComponentPath) {
            this.dataSenseInfo.componentInfoByComponentPath = componentInfoByComponentPath;
            return this;
        }

        public Builder withGlobalBindings(Map<String, MetadataType> globalBindings) {
            this.dataSenseInfo.globalBindings = globalBindings;
            return this;
        }

        public Builder withFunctionBindings(Map<String, MetadataType> functionBindings) {
            this.dataSenseInfo.functionBindings = functionBindings;
            return this;
        }

        public Builder withNotifications(List<DataSenseNotification> notifications) {
            this.dataSenseInfo.notifications = notifications;
            return this;
        }

        public DataSenseInfo build() {
            return this.dataSenseInfo;
        }
    }
}

